/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder.diag;

import io.quarkus.builder.location.Location;
import java.io.PrintStream;
import org.wildfly.common.Assert;

public final class Diagnostic {
    private final Level level;
    private final Location location;
    private final String format;
    private final Object[] args;
    private final Throwable thrown;

    public Diagnostic(Level level, Location location, String format, Object ... args) {
        this(level, null, location, format, args);
    }

    public Diagnostic(Level level, Throwable thrown, Location location, String format, Object ... args) {
        Assert.checkNotNullParam((String)"level", (Object)((Object)level));
        Assert.checkNotNullParam((String)"format", (Object)format);
        Assert.checkNotNullParam((String)"args", (Object)args);
        this.level = level;
        this.location = location;
        this.format = format;
        this.args = (Object[])args.clone();
        this.thrown = thrown;
    }

    public void print(PrintStream os) {
        if (this.location != null) {
            os.print(this.location);
            os.print(": ");
        }
        os.print('[');
        os.print((Object)this.level);
        os.print("]: ");
        os.printf(this.format, this.args);
        if (this.thrown != null) {
            os.print(": ");
            this.thrown.printStackTrace(os);
        }
        os.println();
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder b) {
        if (this.location != null) {
            b.append(this.location).append(": ");
        }
        b.append('[').append((Object)this.level).append("]: ");
        b.append(String.format(this.format, this.args));
        if (this.thrown != null) {
            b.append(": ").append(this.thrown);
        }
        return b;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public Level getLevel() {
        return this.level;
    }

    public static enum Level {
        ERROR("error"),
        WARN("warning"),
        NOTE("note");

        private final String name;

        private Level(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

