/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildStep;
import io.quarkus.builder.Execution;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.Messages;
import io.quarkus.builder.StepInfo;
import io.quarkus.builder.diag.Diagnostic;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.builder.item.NamedBuildItem;
import io.quarkus.builder.item.NamedMultiBuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.builder.location.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.Assert;

public final class BuildContext {
    private final StepInfo stepInfo;
    private final Execution execution;
    private final AtomicInteger dependencies;

    BuildContext(StepInfo stepInfo, Execution execution) {
        this.stepInfo = stepInfo;
        this.execution = execution;
        this.dependencies = new AtomicInteger(stepInfo.getDependencies());
    }

    public String getBuildTargetName() {
        return this.execution.getBuildTargetName();
    }

    public void produce(BuildItem item) {
        Assert.checkNotNullParam((String)"item", (Object)item);
        if (item instanceof NamedBuildItem) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.doProduce(new ItemId(item.getClass(), null), item);
    }

    public void produce(List<? extends MultiBuildItem> items) {
        Assert.checkNotNullParam((String)"items", items);
        for (MultiBuildItem multiBuildItem : items) {
            this.doProduce(new ItemId(multiBuildItem.getClass(), null), multiBuildItem);
        }
    }

    public <T extends BuildItem> void produce(Class<T> type, T item) {
        Assert.checkNotNullParam((String)"type", type);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.doProduce(new ItemId(type, null), (BuildItem)type.cast(item));
    }

    public <N> void produce(N name, NamedBuildItem<N> item) {
        Assert.checkNotNullParam((String)"name", name);
        Assert.checkNotNullParam((String)"item", item);
        this.doProduce(new ItemId(item.getClass(), name), item);
    }

    public <N, T extends NamedBuildItem<N>> void produce(Class<T> type, N name, NamedBuildItem<N> item) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        Assert.checkNotNullParam((String)"item", item);
        this.doProduce(new ItemId(type, name), item);
    }

    public <T extends SimpleBuildItem> T consume(Class<T> type) {
        Assert.checkNotNullParam((String)"type", type);
        ItemId id = new ItemId(type, null);
        if (id.isMulti()) {
            throw Messages.msg.cannotMulti(id);
        }
        if (!this.stepInfo.getConsumes().contains(id)) {
            throw Messages.msg.undeclaredItem(id);
        }
        return (T)((SimpleBuildItem)type.cast(this.execution.getSingles().get(id)));
    }

    public <N, T extends NamedBuildItem<N>> T consume(Class<T> type, N name) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        ItemId id = new ItemId(type, name);
        if (id.isMulti()) {
            throw Messages.msg.cannotMulti(id);
        }
        if (!this.stepInfo.getConsumes().contains(id)) {
            throw Messages.msg.undeclaredItem(id);
        }
        return (T)((NamedBuildItem)type.cast(this.execution.getSingles().get(id)));
    }

    public <T extends MultiBuildItem> List<T> consumeMulti(Class<T> type) {
        Assert.checkNotNullParam((String)"type", type);
        ItemId id = new ItemId(type, null);
        if (!id.isMulti()) {
            throw Messages.msg.cannotMulti(id);
        }
        if (!this.stepInfo.getConsumes().contains(id)) {
            throw Messages.msg.undeclaredItem(id);
        }
        return new ArrayList(this.execution.getMultis().getOrDefault(id, Collections.emptyList()));
    }

    public <N, T extends NamedMultiBuildItem<N>> List<T> consumeMulti(Class<T> type, N name) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        ItemId id = new ItemId(type, name);
        if (!id.isMulti()) {
            throw Messages.msg.cannotMulti(id);
        }
        if (!this.stepInfo.getConsumes().contains(id)) {
            throw Messages.msg.undeclaredItem(id);
        }
        return new ArrayList(this.execution.getMultis().getOrDefault(id, Collections.emptyList()));
    }

    public <T extends MultiBuildItem> List<T> consumeMulti(Class<T> type, Comparator<? super T> comparator) {
        List<T> result = this.consumeMulti(type);
        result.sort(comparator);
        return result;
    }

    public <N, T extends NamedMultiBuildItem<N>> List<T> consumeMulti(Class<T> type, N name, Comparator<? super T> comparator) {
        List<T> result = this.consumeMulti(type, name);
        result.sort(comparator);
        return result;
    }

    public boolean isAvailableToConsume(Class<? extends BuildItem> type) {
        ItemId id = new ItemId(type, null);
        return this.stepInfo.getConsumes().contains(id) && id.isMulti() ? !this.execution.getMultis().getOrDefault(id, Collections.emptyList()).isEmpty() : this.execution.getSingles().containsKey(id);
    }

    public <N> boolean isAvailableToConsume(Class<? extends NamedBuildItem<N>> type, N name) {
        ItemId id = new ItemId(type, name);
        return this.stepInfo.getConsumes().contains(id) && id.isMulti() ? !this.execution.getMultis().getOrDefault(id, Collections.emptyList()).isEmpty() : this.execution.getSingles().containsKey(id);
    }

    public boolean isConsumed(Class<? extends BuildItem> type) {
        return this.execution.getBuildChain().getConsumed().contains(new ItemId(type, null));
    }

    public <N> boolean isConsumed(Class<? extends NamedBuildItem<N>> type, N name) {
        return this.execution.getBuildChain().getConsumed().contains(new ItemId(type, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void note(Location location, String format, Object ... args) {
        List<Diagnostic> list;
        List<Diagnostic> list2 = list = this.execution.getDiagnostics();
        synchronized (list2) {
            list.add(new Diagnostic(Diagnostic.Level.NOTE, location, format, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(Location location, String format, Object ... args) {
        List<Diagnostic> list;
        List<Diagnostic> list2 = list = this.execution.getDiagnostics();
        synchronized (list2) {
            list.add(new Diagnostic(Diagnostic.Level.WARN, location, format, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Location location, String format, Object ... args) {
        List<Diagnostic> list;
        List<Diagnostic> list2 = list = this.execution.getDiagnostics();
        synchronized (list2) {
            list.add(new Diagnostic(Diagnostic.Level.ERROR, location, format, args));
        }
        this.execution.setErrorReported();
    }

    public Executor getExecutor() {
        return this.execution.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProduce(ItemId id, BuildItem value) {
        if (!this.stepInfo.getProduces().contains(id)) {
            throw Messages.msg.undeclaredItem(id);
        }
        if (id.isMulti()) {
            List list;
            List list2 = list = this.execution.getMultis().computeIfAbsent(id, x -> new ArrayList());
            synchronized (list2) {
                if (Comparable.class.isAssignableFrom(id.getType())) {
                    int pos = Collections.binarySearch(list, value);
                    if (pos < 0) {
                        pos = -(pos + 1);
                    }
                    list.add(pos, value);
                } else {
                    list.add(value);
                }
            }
        } else if (this.execution.getSingles().putIfAbsent(id, value) != null) {
            throw Messages.msg.cannotMulti(id);
        }
    }

    void depFinished() {
        int remaining = this.dependencies.decrementAndGet();
        Execution.log.tracef("Dependency of \"%2$s\" finished; %1$d remaining", remaining, (Object)this.stepInfo.getBuildStep());
        if (remaining == 0) {
            this.execution.getExecutor().execute(this::run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        Set<StepInfo> dependents;
        StepInfo stepInfo;
        Execution execution;
        block11: {
            execution = this.execution;
            stepInfo = this.stepInfo;
            BuildStep buildStep = stepInfo.getBuildStep();
            long start = System.currentTimeMillis();
            Execution.log.tracef("Starting step \"%s\"", (Object)buildStep);
            try {
                if (execution.isErrorReported()) break block11;
                try {
                    buildStep.execute(this);
                }
                catch (Throwable t) {
                    List<Diagnostic> list;
                    List<Diagnostic> list2 = list = execution.getDiagnostics();
                    synchronized (list2) {
                        list.add(new Diagnostic(Diagnostic.Level.ERROR, t, null, "Build step %s threw an exception", buildStep));
                    }
                    execution.setErrorReported();
                }
            }
            finally {
                Execution.log.tracef("Finished step \"%s\" in %s ms", (Object)buildStep, (Object)(System.currentTimeMillis() - start));
                execution.removeBuildContext(stepInfo, this);
            }
        }
        if (!(dependents = stepInfo.getDependents()).isEmpty()) {
            for (StepInfo info : dependents) {
                execution.getBuildContext(info).depFinished();
            }
        } else {
            execution.depFinished();
        }
    }
}

