/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.Constraint;
import io.quarkus.builder.Consume;
import io.quarkus.builder.ConsumeFlag;
import io.quarkus.builder.ConsumeFlags;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.Produce;
import io.quarkus.builder.ProduceFlag;
import io.quarkus.builder.ProduceFlags;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.NamedBuildItem;
import io.quarkus.builder.item.SymbolicBuildItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.wildfly.common.Assert;

public final class BuildStepBuilder {
    private final BuildChainBuilder buildChainBuilder;
    private final Map<ItemId, Consume> consumes = new HashMap<ItemId, Consume>();
    private final Map<ItemId, Produce> produces = new HashMap<ItemId, Produce>();
    private BuildStep buildStep;

    BuildStepBuilder(BuildChainBuilder buildChainBuilder) {
        this.buildChainBuilder = buildChainBuilder;
    }

    public BuildStepBuilder setBuildStep(BuildStep buildStep) {
        this.buildStep = buildStep;
        return this;
    }

    public BuildStepBuilder beforeConsume(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot consume a named build item without a name");
        }
        this.addProduces(new ItemId(type, null), Constraint.ORDER_ONLY, ProduceFlags.NONE);
        return this;
    }

    public BuildStepBuilder beforeConsume(Class<? extends BuildItem> type, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot consume a named build item without a name");
        }
        this.addProduces(new ItemId(type, null), Constraint.ORDER_ONLY, ProduceFlags.of(flag));
        return this;
    }

    public <N> BuildStepBuilder beforeConsume(Class<? extends NamedBuildItem<N>> type, N name) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        this.addProduces(new ItemId(type, name), Constraint.ORDER_ONLY, ProduceFlags.NONE);
        return this;
    }

    public <N> BuildStepBuilder beforeConsume(Class<? extends NamedBuildItem<N>> type, N name, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        this.addProduces(new ItemId(type, name), Constraint.ORDER_ONLY, ProduceFlags.of(flag));
        return this;
    }

    public BuildStepBuilder afterProduce(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.addConsumes(new ItemId(type, null), Constraint.ORDER_ONLY, ConsumeFlags.of(ConsumeFlag.OPTIONAL));
        return this;
    }

    public <N> BuildStepBuilder afterProduce(Class<? extends NamedBuildItem<N>> type, N name) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        this.addConsumes(new ItemId(type, name), Constraint.ORDER_ONLY, ConsumeFlags.of(ConsumeFlag.OPTIONAL));
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.addProduces(new ItemId(type, null), Constraint.REAL, ProduceFlags.NONE);
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.addProduces(new ItemId(type, null), Constraint.REAL, ProduceFlags.of(flag));
        return this;
    }

    public BuildStepBuilder produces(Class<? extends BuildItem> type, ProduceFlags flags) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flags));
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.addProduces(new ItemId(type, null), Constraint.REAL, flags);
        return this;
    }

    public <N> BuildStepBuilder produces(Class<? extends NamedBuildItem<N>> type, N name) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        this.addProduces(new ItemId(type, name), Constraint.REAL, ProduceFlags.NONE);
        return this;
    }

    public <N> BuildStepBuilder produces(Class<? extends NamedBuildItem<N>> type, N name, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        this.addProduces(new ItemId(type, name), Constraint.REAL, ProduceFlags.of(flag));
        return this;
    }

    public BuildStepBuilder beforeVirtual(Enum<?> symbolic) {
        Assert.checkNotNullParam((String)"symbolic", symbolic);
        this.addProduces(new ItemId(SymbolicBuildItem.class, symbolic), Constraint.ORDER_ONLY, ProduceFlags.NONE);
        return this;
    }

    public BuildStepBuilder beforeVirtual(Enum<?> symbolic, ProduceFlag flag) {
        Assert.checkNotNullParam((String)"symbolic", symbolic);
        Assert.checkNotNullParam((String)"flag", (Object)((Object)flag));
        this.addProduces(new ItemId(SymbolicBuildItem.class, symbolic), Constraint.ORDER_ONLY, ProduceFlags.of(flag));
        return this;
    }

    public BuildStepBuilder consumes(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot consume a named build item without a name");
        }
        this.addConsumes(new ItemId(type, null), Constraint.REAL, ConsumeFlags.NONE);
        return this;
    }

    public <N> BuildStepBuilder consumes(Class<? extends NamedBuildItem<N>> type, N name) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        this.addConsumes(new ItemId(type, name), Constraint.REAL, ConsumeFlags.NONE);
        return this;
    }

    public BuildStepBuilder consumes(Class<? extends BuildItem> type, ConsumeFlags flags) {
        Assert.checkNotNullParam((String)"type", type);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot consume a named build item without a name");
        }
        this.addConsumes(new ItemId(type, null), Constraint.REAL, flags);
        return this;
    }

    public <N> BuildStepBuilder consumes(Class<? extends NamedBuildItem<N>> type, N name, ConsumeFlags flags) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        this.addConsumes(new ItemId(type, name), Constraint.REAL, flags);
        return this;
    }

    public BuildStepBuilder afterVirtual(Enum<?> symbolic) {
        this.addConsumes(new ItemId(SymbolicBuildItem.class, symbolic), Constraint.REAL, ConsumeFlags.NONE);
        return this;
    }

    public BuildStepBuilder afterVirtual(Enum<?> symbolic, ConsumeFlags flags) {
        this.addConsumes(new ItemId(SymbolicBuildItem.class, symbolic), Constraint.REAL, flags);
        return this;
    }

    public BuildChainBuilder build() {
        BuildChainBuilder chainBuilder = this.buildChainBuilder;
        chainBuilder.addStep(this, new Exception().getStackTrace());
        return chainBuilder;
    }

    BuildStep getBuildStep() {
        return this.buildStep;
    }

    private void addConsumes(ItemId itemId, Constraint constraint, ConsumeFlags flags) {
        Assert.checkNotNullParam((String)"flags", (Object)((Object)flags));
        this.consumes.compute(itemId, (id, c) -> c == null ? new Consume(this, itemId, constraint, flags) : c.combine(constraint, flags));
    }

    private void addProduces(ItemId itemId, Constraint constraint, ProduceFlags flags) {
        this.produces.compute(itemId, (id, p) -> p == null ? new Produce(this, itemId, constraint, flags) : p.combine(constraint, flags));
    }

    Map<ItemId, Consume> getConsumes() {
        return this.consumes;
    }

    Map<ItemId, Produce> getProduces() {
        return this.produces;
    }

    Set<ItemId> getRealConsumes() {
        HashMap<ItemId, Consume> map = new HashMap<ItemId, Consume>(this.consumes);
        map.entrySet().removeIf(e -> ((Consume)e.getValue()).getConstraint() == Constraint.ORDER_ONLY);
        return map.keySet();
    }

    Set<ItemId> getRealProduces() {
        HashMap<ItemId, Produce> map = new HashMap<ItemId, Produce>(this.produces);
        map.entrySet().removeIf(e -> ((Produce)e.getValue()).getConstraint() == Constraint.ORDER_ONLY);
        return map.keySet();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BuildStep [");
        builder.append(this.buildStep);
        builder.append("]");
        return builder.toString();
    }
}

