/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.cache.deployment.AdditionalCacheNameBuildItem;
import io.quarkus.cache.deployment.CacheAnnotationsTransformer;
import io.quarkus.cache.deployment.CacheConfig;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.deployment.CacheMethodValidator;
import io.quarkus.cache.deployment.CaffeineCacheInfoBuilder;
import io.quarkus.cache.runtime.CacheInvalidateAllInterceptor;
import io.quarkus.cache.runtime.CacheInvalidateInterceptor;
import io.quarkus.cache.runtime.CacheResultInterceptor;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheBuildRecorder;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

class CacheProcessor {
    CacheProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.CACHE);
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationsTransformer() {
        return new AnnotationsTransformerBuildItem((AnnotationsTransformer)new CacheAnnotationsTransformer());
    }

    @BuildStep
    List<AdditionalBeanBuildItem> additionalBeans() {
        return Arrays.asList(new AdditionalBeanBuildItem(new Class[]{CacheInvalidateAllInterceptor.class}), new AdditionalBeanBuildItem(new Class[]{CacheInvalidateInterceptor.class}), new AdditionalBeanBuildItem(new Class[]{CacheResultInterceptor.class}));
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validateBeanDeployment(ValidationPhaseBuildItem validationPhase) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (BeanInfo bean : (Collection)validationPhase.getContext().get(BuildExtension.Key.BEANS)) {
            if (!bean.isClassBean()) continue;
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                if (!annotationStore.hasAnyAnnotation((AnnotationTarget)method, CacheDeploymentConstants.API_METHODS_ANNOTATIONS)) continue;
                CacheMethodValidator.validateAnnotations(annotationStore, bean, method, throwables);
            }
        }
        return new ValidationPhaseBuildItem.ValidationErrorBuildItem(throwables.toArray(new Throwable[0]));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void recordCachesBuild(CombinedIndexBuildItem combinedIndex, BeanContainerBuildItem beanContainer, CacheConfig config, CaffeineCacheBuildRecorder caffeineRecorder, List<AdditionalCacheNameBuildItem> additionalCacheNames) {
        Set<String> cacheNames = this.getCacheNames(combinedIndex.getIndex());
        for (AdditionalCacheNameBuildItem additionalCacheName : additionalCacheNames) {
            cacheNames.add(additionalCacheName.getName());
        }
        switch (config.type) {
            case "caffeine": {
                Set<CaffeineCacheInfo> cacheInfos = CaffeineCacheInfoBuilder.build(cacheNames, config);
                caffeineRecorder.buildCaches(beanContainer.getValue(), cacheInfos);
                break;
            }
            default: {
                throw new DeploymentException("Unknown cache type: " + config.type);
            }
        }
    }

    private Set<String> getCacheNames(IndexView index) {
        HashSet<String> cacheNames = new HashSet<String>();
        for (DotName cacheAnnotation : CacheDeploymentConstants.API_METHODS_ANNOTATIONS) {
            for (AnnotationInstance annotation : index.getAnnotations(cacheAnnotation)) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                cacheNames.add(annotation.value("cacheName").asString());
            }
        }
        for (DotName list : CacheDeploymentConstants.API_METHODS_ANNOTATIONS_LISTS) {
            for (AnnotationInstance annotation : index.getAnnotations(list)) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                for (AnnotationInstance nestedAnnotation : annotation.value("value").asNestedArray()) {
                    cacheNames.add(nestedAnnotation.value("cacheName").asString());
                }
            }
        }
        return cacheNames;
    }
}

