/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.deployment.exception.IllegalReturnTypeException;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class CacheMethodValidator {
    public static void validateAnnotations(AnnotationStore annotationStore, BeanInfo bean, MethodInfo method, List<Throwable> throwables) {
        AnnotationInstance cacheResult = annotationStore.getAnnotation((AnnotationTarget)method, CacheDeploymentConstants.CACHE_RESULT);
        if (cacheResult != null && method.returnType().kind() == Type.Kind.VOID) {
            String exceptionMessage = "The @CacheResult annotation is not allowed on a method returning void: [class= " + bean.getBeanClass() + ", method= " + method + "]";
            throwables.add(new IllegalReturnTypeException(exceptionMessage));
        }
    }
}

