/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.cache.runtime.DefaultCacheKey;
import io.quarkus.cache.runtime.NullValueConverter;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class CaffeineCache {
    public static final String NULL_KEYS_NOT_SUPPORTED_MSG = "Null keys are not supported by the Quarkus application data cache";
    private AsyncCache<Object, Object> cache;
    private String name;
    private Integer initialCapacity;
    private Long maximumSize;
    private Duration expireAfterWrite;
    private Duration expireAfterAccess;
    private Object defaultKey;

    public CaffeineCache(CaffeineCacheInfo cacheInfo) {
        this.name = cacheInfo.name;
        Caffeine builder = Caffeine.newBuilder();
        if (cacheInfo.initialCapacity != null) {
            this.initialCapacity = cacheInfo.initialCapacity;
            builder.initialCapacity(cacheInfo.initialCapacity.intValue());
        }
        if (cacheInfo.maximumSize != null) {
            this.maximumSize = cacheInfo.maximumSize;
            builder.maximumSize(cacheInfo.maximumSize.longValue());
        }
        if (cacheInfo.expireAfterWrite != null) {
            this.expireAfterWrite = cacheInfo.expireAfterWrite;
            builder.expireAfterWrite(cacheInfo.expireAfterWrite);
        }
        if (cacheInfo.expireAfterAccess != null) {
            this.expireAfterAccess = cacheInfo.expireAfterAccess;
            builder.expireAfterAccess(cacheInfo.expireAfterAccess);
        }
        this.cache = builder.buildAsync();
    }

    public CompletableFuture<Object> get(Object key, Function<Object, Object> valueLoader) {
        if (key == null) {
            throw new NullPointerException(NULL_KEYS_NOT_SUPPORTED_MSG);
        }
        CompletableFuture<Object> newCacheValue = new CompletableFuture<Object>();
        CompletableFuture<Object> existingCacheValue = this.cache.asMap().putIfAbsent(key, newCacheValue);
        if (existingCacheValue == null) {
            Object value = valueLoader.apply(key);
            newCacheValue.complete(NullValueConverter.toCacheValue(value));
            return this.unwrapCacheValue(newCacheValue);
        }
        return this.unwrapCacheValue(existingCacheValue);
    }

    private CompletableFuture<Object> unwrapCacheValue(CompletableFuture<Object> cacheValue) {
        return cacheValue.thenApply(new Function<Object, Object>(){

            @Override
            public Object apply(Object value) {
                return NullValueConverter.fromCacheValue(value);
            }
        });
    }

    public void invalidate(Object key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEYS_NOT_SUPPORTED_MSG);
        }
        this.cache.synchronous().invalidate(key);
    }

    public void invalidateAll() {
        this.cache.synchronous().invalidateAll();
    }

    public String getName() {
        return this.name;
    }

    public Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    public Long getMaximumSize() {
        return this.maximumSize;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public Object getDefaultKey() {
        if (this.defaultKey == null) {
            this.defaultKey = new DefaultCacheKey(this.getName());
        }
        return this.defaultKey;
    }
}

