/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheKeyParameterPositions;
import io.quarkus.cache.runtime.CompositeCacheKey;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;

public abstract class CacheInterceptor {
    public static final int BASE_PRIORITY = 0;
    @Inject
    CacheManager cacheManager;

    protected <T extends Annotation> List<T> getInterceptorBindings(InvocationContext context, Class<T> bindingClass) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation binding : InterceptorBindings.getInterceptorBindings((InvocationContext)context)) {
            if (!bindingClass.isInstance(binding)) continue;
            bindings.add(binding);
        }
        return bindings;
    }

    protected <T extends Annotation> T getInterceptorBinding(InvocationContext context, Class<T> bindingClass) {
        return (T)((Annotation)this.getInterceptorBindings(context, bindingClass).get(0));
    }

    protected short[] getCacheKeyParameterPositions(InvocationContext context) {
        List<CacheKeyParameterPositions> bindings = this.getInterceptorBindings(context, CacheKeyParameterPositions.class);
        if (bindings.isEmpty()) {
            return new short[0];
        }
        return bindings.get(0).value();
    }

    protected Object getCacheKey(AbstractCache cache, short[] cacheKeyParameterPositions, Object[] methodParameterValues) {
        if (methodParameterValues == null || methodParameterValues.length == 0) {
            return cache.getDefaultKey();
        }
        if (cacheKeyParameterPositions.length == 1) {
            return methodParameterValues[cacheKeyParameterPositions[0]];
        }
        if (cacheKeyParameterPositions.length >= 2) {
            ArrayList<Object> keyElements = new ArrayList<Object>();
            for (int i = 0; i < cacheKeyParameterPositions.length; ++i) {
                keyElements.add(methodParameterValues[cacheKeyParameterPositions[i]]);
            }
            return new CompositeCacheKey(keyElements.toArray(new Object[0]));
        }
        if (methodParameterValues.length == 1) {
            return methodParameterValues[0];
        }
        return new CompositeCacheKey(methodParameterValues);
    }
}

