/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.CacheInvalidateInterceptorBinding;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheInvalidateInterceptorBinding
@Interceptor
@Priority(value=1)
public class CacheInvalidateInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateInterceptor.class);

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Object key = null;
        short[] cacheKeyParameterPositions = this.getCacheKeyParameterPositions(context);
        for (CacheInvalidateInterceptorBinding binding : this.getInterceptorBindings(context, CacheInvalidateInterceptorBinding.class)) {
            AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
            if (key == null) {
                key = this.getCacheKey(cache, cacheKeyParameterPositions, context.getParameters());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Invalidating entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
            }
            cache.invalidate(key);
        }
        return context.proceed();
    }
}

