/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheException;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.CacheResultInterceptorBinding;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheResultInterceptorBinding
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);

    @AroundInvoke
    public Object intercept(final InvocationContext context) throws Exception {
        CacheResultInterceptorBinding binding = this.getInterceptorBinding(context, CacheResultInterceptorBinding.class);
        AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
        short[] cacheKeyParameterPositions = this.getCacheKeyParameterPositions(context);
        Object key = this.getCacheKey(cache, cacheKeyParameterPositions, context.getParameters());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        }
        try {
            CompletableFuture<Object> cacheValue = cache.get(key, new Function<Object, Object>(){

                @Override
                public Object apply(Object k) {
                    try {
                        return context.proceed();
                    }
                    catch (Exception e) {
                        throw new CacheException(e);
                    }
                }
            });
            if (binding.lockTimeout() <= 0L) {
                return cacheValue.get();
            }
            try {
                return cacheValue.get(binding.lockTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                return context.proceed();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CacheException) {
                CacheException cacheException = (CacheException)e.getCause();
                if (cacheException.getCause() instanceof Exception) {
                    throw (Exception)cacheException.getCause();
                }
                throw cacheException;
            }
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }
}

