/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.cache.CacheKey;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheKeyParameterPositions;
import io.quarkus.cache.runtime.CompositeCacheKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;

public abstract class CacheInterceptor {
    public static final int BASE_PRIORITY = 0;
    @Inject
    CacheManager cacheManager;

    protected <T extends Annotation> CacheInterceptionContext<T> getInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        return this.getArcCacheInterceptionContext(invocationContext, interceptorBindingClass).orElse(this.getNonArcCacheInterceptionContext(invocationContext, interceptorBindingClass));
    }

    private <T extends Annotation> Optional<CacheInterceptionContext<T>> getArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        Set bindings = InterceptorBindings.getInterceptorBindings((InvocationContext)invocationContext);
        if (bindings == null) {
            return Optional.empty();
        }
        ArrayList<T> interceptorBindings = new ArrayList<T>();
        ArrayList<Short> cacheKeyParameterPositions = new ArrayList<Short>();
        for (Annotation binding : bindings) {
            if (binding instanceof CacheKeyParameterPositions) {
                for (short position : ((CacheKeyParameterPositions)binding).value()) {
                    cacheKeyParameterPositions.add(position);
                }
                continue;
            }
            if (!interceptorBindingClass.isInstance(binding)) continue;
            interceptorBindings.add(this.cast(binding, interceptorBindingClass));
        }
        return Optional.of(new CacheInterceptionContext(interceptorBindings, cacheKeyParameterPositions));
    }

    private <T extends Annotation> CacheInterceptionContext<T> getNonArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        ArrayList<T> interceptorBindings = new ArrayList<T>();
        ArrayList<Short> cacheKeyParameterPositions = new ArrayList<Short>();
        for (Annotation annotation : invocationContext.getMethod().getAnnotations()) {
            if (!interceptorBindingClass.isInstance(annotation)) continue;
            interceptorBindings.add(this.cast(annotation, interceptorBindingClass));
        }
        Parameter[] parameters = invocationContext.getMethod().getParameters();
        if (parameters.length > 0) {
            for (short i = 0; i < parameters.length; i = (short)(i + 1)) {
                if (!parameters[i].isAnnotationPresent(CacheKey.class)) continue;
                cacheKeyParameterPositions.add(i);
            }
        }
        return new CacheInterceptionContext(interceptorBindings, cacheKeyParameterPositions);
    }

    private <T extends Annotation> T cast(Annotation annotation, Class<T> interceptorBindingClass) {
        return (T)annotation;
    }

    protected Object getCacheKey(AbstractCache cache, List<Short> cacheKeyParameterPositions, Object[] methodParameterValues) {
        if (methodParameterValues == null || methodParameterValues.length == 0) {
            return cache.getDefaultKey();
        }
        if (cacheKeyParameterPositions.size() == 1) {
            return methodParameterValues[cacheKeyParameterPositions.get(0)];
        }
        if (cacheKeyParameterPositions.size() >= 2) {
            ArrayList<Object> keyElements = new ArrayList<Object>();
            for (short position : cacheKeyParameterPositions) {
                keyElements.add(methodParameterValues[position]);
            }
            return new CompositeCacheKey(keyElements.toArray(new Object[0]));
        }
        if (methodParameterValues.length == 1) {
            return methodParameterValues[0];
        }
        return new CompositeCacheKey(methodParameterValues);
    }
}

