/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.devconsole;

import io.quarkus.cache.Cache;
import io.quarkus.cache.runtime.CaffeineCacheSupplier;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;

@Recorder
public class CacheDevConsoleRecorder {
    public Handler<RoutingContext> clearCacheHandler() {
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String cacheName = form.get("name");
                Optional<Cache> cache = CaffeineCacheSupplier.cacheManager().getCache(cacheName);
                if (cache.isPresent() && cache.get() instanceof CaffeineCache) {
                    ((CaffeineCache)cache.get()).invalidateAll();
                    this.flashMessage(event, "Cache for " + cacheName + " cleared");
                    return;
                }
                this.flashMessage(event, "Cache for " + cacheName + " not found", FlashScopeUtil.FlashMessageStatus.ERROR);
            }
        };
    }
}

