/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class CacheManagerImpl
implements CacheManager {
    private Map<String, Cache> caches = Collections.emptyMap();
    private Set<String> cacheNames = Collections.emptySet();

    public void setCaches(Map<String, Cache> caches) {
        if (this.caches != Collections.EMPTY_MAP) {
            throw new IllegalStateException("The caches map must only be set once at build time");
        }
        this.caches = Collections.unmodifiableMap(caches);
        this.cacheNames = Collections.unmodifiableSet(caches.keySet());
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    @Override
    public Optional<Cache> getCache(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.caches.get(name));
    }
}

