/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheResult;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheException;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheResult(cacheName="")
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);
    private static final String INTERCEPTOR_BINDING_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheResult interceptor binding retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(final InvocationContext invocationContext) throws Throwable {
        CacheInterceptionContext<CacheResult> interceptionContext = this.getInterceptionContext(invocationContext, CacheResult.class);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDING_ERROR_MSG);
            return invocationContext.proceed();
        }
        CacheResult binding = interceptionContext.getInterceptorBindings().get(0);
        AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
        Object key = this.getCacheKey(cache, interceptionContext.getCacheKeyParameterPositions(), invocationContext.getParameters());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        }
        try {
            CompletableFuture<Object> cacheValue = cache.get(key, new Function<Object, Object>(){

                @Override
                public Object apply(Object k) {
                    try {
                        return invocationContext.proceed();
                    }
                    catch (Exception e) {
                        throw new CacheException(e);
                    }
                }
            });
            if (binding.lockTimeout() <= 0L) {
                return cacheValue.get();
            }
            try {
                return cacheValue.get(binding.lockTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                return invocationContext.proceed();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CacheException) {
                if (e.getCause().getCause() != null) {
                    throw e.getCause().getCause();
                }
                throw e.getCause();
            }
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }
}

