/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheInvalidate;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheInvalidate(cacheName="")
@Interceptor
@Priority(value=1)
public class CacheInvalidateInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateInterceptor.class);
    private static final String INTERCEPTOR_BINDINGS_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheInvalidate interceptor bindings retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        CacheInterceptionContext<CacheInvalidate> interceptionContext = this.getInterceptionContext(invocationContext, CacheInvalidate.class, true);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDINGS_ERROR_MSG);
        } else {
            Object key = null;
            for (CacheInvalidate binding : interceptionContext.getInterceptorBindings()) {
                AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
                if (key == null) {
                    key = this.getCacheKey(cache, interceptionContext.getCacheKeyParameterPositions(), invocationContext.getParameters());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Invalidating entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
                }
                cache.invalidate(key);
            }
        }
        return invocationContext.proceed();
    }
}

