/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.augmented;

import io.quarkus.cache.runtime.augmented.AugmentedCacheAnnotationInterceptor;
import io.quarkus.cache.runtime.augmented.AugmentedCacheInvalidate;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@AugmentedCacheInvalidate
@Interceptor
@Priority(value=0)
public class AugmentedCacheInvalidateInterceptor
extends AugmentedCacheAnnotationInterceptor {
    private static final Logger LOGGER = Logger.getLogger(AugmentedCacheInvalidateInterceptor.class);

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        AugmentedCacheInvalidate annotation = this.getCacheAnnotation(context, AugmentedCacheInvalidate.class);
        CaffeineCache cache = this.cacheRepository.getCache(annotation.cacheName());
        Object key = this.getCacheKey(context, cache.getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Invalidating entry with key [%s] from cache [%s]", key, (Object)cache.getName());
        }
        cache.invalidate(key);
        return context.proceed();
    }
}

