/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.cache.runtime.CacheRepository;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.logging.Logger;

@Recorder
public class CaffeineCacheBuildRecorder {
    private static final Logger LOGGER = Logger.getLogger(CaffeineCacheBuildRecorder.class);

    public void buildCaches(boolean managedExecutorInitialized, BeanContainer beanContainer, Set<CaffeineCacheInfo> cacheInfos) {
        HashMap<String, CaffeineCache> caches = new HashMap<String, CaffeineCache>(cacheInfos.size() + 1, 1.0f);
        ManagedExecutor managedExecutor = null;
        if (managedExecutorInitialized) {
            managedExecutor = (ManagedExecutor)beanContainer.instance(ManagedExecutor.class, new Annotation[0]);
        }
        for (CaffeineCacheInfo cacheInfo : cacheInfos) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Building Caffeine cache [%s] with [initialCapacity=%s], [maximumSize=%s], [expireAfterWrite=%s] and [expireAfterAccess=%s]", new Object[]{cacheInfo.name, cacheInfo.initialCapacity, cacheInfo.maximumSize, cacheInfo.expireAfterWrite, cacheInfo.expireAfterAccess});
            }
            CaffeineCache cache = new CaffeineCache(cacheInfo, (Executor)managedExecutor);
            caches.put(cacheInfo.name, cache);
        }
        ((CacheRepository)beanContainer.instance(CacheRepository.class, new Annotation[0])).setCaches(caches);
    }
}

