/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.CacheResultInterceptorBinding;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheResultInterceptorBinding
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        CacheResultInterceptorBinding binding = this.getInterceptorBinding(context, CacheResultInterceptorBinding.class);
        Object key = this.buildCacheKey(binding.cacheName(), binding.cacheKeyParameterPositions(), context.getParameters());
        CaffeineCache cache = this.cacheRepository.getCache(binding.cacheName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)cache.getName());
        }
        return cache.get(key, () -> context.proceed(), binding.lockTimeout());
    }
}

