/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.cache.runtime.CacheException;
import io.quarkus.cache.runtime.NullValueConverter;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class CaffeineCache {
    private AsyncCache<Object, Object> cache;
    private String name;
    private Integer initialCapacity;
    private Long maximumSize;
    private Duration expireAfterWrite;
    private Duration expireAfterAccess;

    public CaffeineCache(CaffeineCacheInfo cacheInfo, Executor executor) {
        this.name = cacheInfo.name;
        Caffeine builder = Caffeine.newBuilder();
        if (executor != null) {
            builder.executor(executor);
        }
        if (cacheInfo.initialCapacity != null) {
            this.initialCapacity = cacheInfo.initialCapacity;
            builder.initialCapacity(cacheInfo.initialCapacity.intValue());
        }
        if (cacheInfo.maximumSize != null) {
            this.maximumSize = cacheInfo.maximumSize;
            builder.maximumSize(cacheInfo.maximumSize.longValue());
        }
        if (cacheInfo.expireAfterWrite != null) {
            this.expireAfterWrite = cacheInfo.expireAfterWrite;
            builder.expireAfterWrite(cacheInfo.expireAfterWrite);
        }
        if (cacheInfo.expireAfterAccess != null) {
            this.expireAfterAccess = cacheInfo.expireAfterAccess;
            builder.expireAfterAccess(cacheInfo.expireAfterAccess);
        }
        this.cache = builder.buildAsync();
    }

    public Object get(Object key, Callable<Object> valueLoader, long lockTimeout) throws Exception {
        if (lockTimeout <= 0L) {
            try {
                return NullValueConverter.fromCacheValue(this.cache.synchronous().get(key, k -> new MappingSupplier(valueLoader).get()));
            }
            catch (CacheException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }
        boolean[] isCurrentThreadComputation = new boolean[]{false};
        CompletableFuture future = this.cache.get(key, (k, executor) -> {
            isCurrentThreadComputation[0] = true;
            return CompletableFuture.supplyAsync(new MappingSupplier(valueLoader), executor);
        });
        if (isCurrentThreadComputation[0]) {
            try {
                return NullValueConverter.fromCacheValue(future.get());
            }
            catch (ExecutionException e) {
                throw this.getExceptionToThrow(e);
            }
        }
        try {
            return NullValueConverter.fromCacheValue(future.get(lockTimeout, TimeUnit.MILLISECONDS));
        }
        catch (ExecutionException e) {
            throw this.getExceptionToThrow(e);
        }
        catch (TimeoutException e) {
            return valueLoader.call();
        }
    }

    public void invalidate(Object key) {
        this.cache.synchronous().invalidate(key);
    }

    public void invalidateAll() {
        this.cache.synchronous().invalidateAll();
    }

    public String getName() {
        return this.name;
    }

    public Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    public Long getMaximumSize() {
        return this.maximumSize;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    private Exception getExceptionToThrow(ExecutionException e) {
        if (e.getCause() instanceof CacheException && e.getCause().getCause() instanceof Exception) {
            return (Exception)e.getCause().getCause();
        }
        return e;
    }

    private static class MappingSupplier
    implements Supplier<Object> {
        private final Callable<?> valueLoader;

        public MappingSupplier(Callable<?> valueLoader) {
            this.valueLoader = valueLoader;
        }

        @Override
        public Object get() {
            try {
                return NullValueConverter.toCacheValue(this.valueLoader.call());
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        }
    }
}

