/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.runtime.CacheException;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.CacheResultInterceptorBinding;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheResultInterceptorBinding
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);

    @AroundInvoke
    public Object intercept(final InvocationContext context) throws Exception {
        CacheResultInterceptorBinding binding = this.getInterceptorBinding(context, CacheResultInterceptorBinding.class);
        CaffeineCache cache = this.cacheRepository.getCache(binding.cacheName());
        Object key = this.getCacheKey(cache, binding.cacheKeyParameterPositions(), context.getParameters());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)cache.getName());
        }
        if (binding.lockTimeout() <= 0L) {
            CompletableFuture<Object> cacheValue = cache.get(key, new BiFunction<Object, Executor, CompletableFuture<Object>>(){

                @Override
                public CompletableFuture<Object> apply(Object k, Executor executor) {
                    return CacheResultInterceptor.this.getValueLoader(context, executor);
                }
            });
            try {
                return cacheValue.get();
            }
            catch (ExecutionException e) {
                throw this.getExceptionToThrow(e);
            }
        }
        final boolean[] isCurrentThreadComputation = new boolean[]{false};
        CompletableFuture<Object> cacheValue = cache.get(key, new BiFunction<Object, Executor, CompletableFuture<Object>>(){

            @Override
            public CompletableFuture<Object> apply(Object k, Executor executor) {
                isCurrentThreadComputation[0] = true;
                return CacheResultInterceptor.this.getValueLoader(context, executor);
            }
        });
        if (isCurrentThreadComputation[0]) {
            try {
                return cacheValue.get();
            }
            catch (ExecutionException e) {
                throw this.getExceptionToThrow(e);
            }
        }
        try {
            return cacheValue.get(binding.lockTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw this.getExceptionToThrow(e);
        }
        catch (TimeoutException e) {
            return context.proceed();
        }
    }

    private CompletableFuture<Object> getValueLoader(final InvocationContext context, Executor executor) {
        return CompletableFuture.supplyAsync(new Supplier<Object>(){

            @Override
            public Object get() {
                try {
                    return context.proceed();
                }
                catch (Exception e) {
                    throw new CacheException(e);
                }
            }
        }, executor);
    }

    private Exception getExceptionToThrow(ExecutionException e) {
        if (e.getCause() instanceof CacheException && e.getCause().getCause() instanceof Exception) {
            return (Exception)e.getCause().getCause();
        }
        return e;
    }
}

