/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheException;
import io.quarkus.cache.CacheResult;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.UnresolvedUniValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheResult(cacheName="")
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);
    private static final String INTERCEPTOR_BINDING_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheResult interceptor binding retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(final InvocationContext invocationContext) throws Throwable {
        if (Multi.class.isAssignableFrom(invocationContext.getMethod().getReturnType())) {
            return invocationContext.proceed();
        }
        CacheInterceptionContext<CacheResult> interceptionContext = this.getInterceptionContext(invocationContext, CacheResult.class, true);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDING_ERROR_MSG);
            return invocationContext.proceed();
        }
        final CacheResult binding = interceptionContext.getInterceptorBindings().get(0);
        final AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
        final Object key = this.getCacheKey(cache, binding.keyGenerator(), interceptionContext.getCacheKeyParameterPositions(), invocationContext.getMethod(), invocationContext.getParameters());
        LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        try {
            Object value;
            final CacheInterceptor.ReturnType returnType = CacheResultInterceptor.determineReturnType(invocationContext.getMethod().getReturnType());
            if (returnType != CacheInterceptor.ReturnType.NonAsync) {
                final Context context = Vertx.currentContext();
                Uni cacheValue = cache.get(key, new Function<Object, Object>(){

                    @Override
                    public Object apply(Object k) {
                        LOGGER.debugf("Adding %s entry with key [%s] into cache [%s]", (Object)UnresolvedUniValue.class.getSimpleName(), key, (Object)binding.cacheName());
                        return UnresolvedUniValue.INSTANCE;
                    }
                }).onItem().transformToUni(new Function<Object, Uni<?>>(){

                    @Override
                    public Uni<?> apply(Object value) {
                        if (value == UnresolvedUniValue.INSTANCE) {
                            try {
                                return CacheResultInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType).call(new Function<Object, Uni<?>>(){

                                    @Override
                                    public Uni<?> apply(Object emittedValue) {
                                        return cache.replaceUniValue(key, emittedValue);
                                    }
                                });
                            }
                            catch (CacheException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new CacheException(e);
                            }
                        }
                        return Uni.createFrom().item(value);
                    }
                }).emitOn(new Executor(){

                    @Override
                    public void execute(Runnable command) {
                        CacheResultInterceptor.invokeOnContext(command, context);
                    }
                });
                if (binding.lockTimeout() <= 0L) {
                    return this.createAsyncResult((Uni<Object>)cacheValue, returnType);
                }
                cacheValue = cacheValue.ifNoItem().after(Duration.ofMillis(binding.lockTimeout())).recoverWithUni(new Supplier<Uni<?>>(){

                    @Override
                    public Uni<?> get() {
                        try {
                            return CacheResultInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType);
                        }
                        catch (CacheException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new CacheException(e);
                        }
                    }
                }).emitOn(new Executor(){

                    @Override
                    public void execute(Runnable command) {
                        CacheResultInterceptor.invokeOnContext(command, context);
                    }
                });
                return this.createAsyncResult((Uni<Object>)cacheValue, returnType);
            }
            Uni<Object> cacheValue = cache.get(key, new Function<Object, Object>(){

                @Override
                public Object apply(Object k) {
                    try {
                        LOGGER.debugf("Adding entry with key [%s] into cache [%s]", key, (Object)binding.cacheName());
                        return invocationContext.proceed();
                    }
                    catch (CacheException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new CacheException(e);
                    }
                }
            });
            if (binding.lockTimeout() <= 0L) {
                value = cacheValue.await().indefinitely();
            } else {
                try {
                    value = cacheValue.await().atMost(Duration.ofMillis(binding.lockTimeout()));
                }
                catch (TimeoutException e) {
                    return invocationContext.proceed();
                }
            }
            return value;
        }
        catch (CacheException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    private static void invokeOnContext(final Runnable command, Context context) {
        Context ctx = Vertx.currentContext();
        if (context == null) {
            if (ctx == null) {
                command.run();
            } else {
                ((ContextInternal)ctx).duplicate().runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void ignored) {
                        command.run();
                    }
                });
            }
        } else if (ctx == context) {
            command.run();
        } else {
            context.runOnContext((Handler)new Handler<Void>(){

                public void handle(Void ignored) {
                    command.run();
                }
            });
        }
    }
}

