/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.ConcurrentStatsCounter;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.quarkus.cache.CacheException;
import io.quarkus.cache.CaffeineCache;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.NullValueConverter;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.cache.runtime.caffeine.CaffeineComputationThrowable;
import io.smallrye.mutiny.Uni;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class CaffeineCacheImpl
extends AbstractCache
implements CaffeineCache {
    private static final Logger LOGGER = Logger.getLogger(CaffeineCacheImpl.class);
    final AsyncCache<Object, Object> cache;
    private final CaffeineCacheInfo cacheInfo;
    private final StatsCounter statsCounter;

    public CaffeineCacheImpl(CaffeineCacheInfo cacheInfo, boolean recordStats) {
        this.cacheInfo = cacheInfo;
        Caffeine builder = Caffeine.newBuilder();
        if (cacheInfo.initialCapacity != null) {
            builder.initialCapacity(cacheInfo.initialCapacity.intValue());
        }
        if (cacheInfo.maximumSize != null) {
            builder.maximumSize(cacheInfo.maximumSize.longValue());
        }
        if (cacheInfo.expireAfterWrite != null) {
            builder.expireAfterWrite(cacheInfo.expireAfterWrite);
        }
        if (cacheInfo.expireAfterAccess != null) {
            builder.expireAfterAccess(cacheInfo.expireAfterAccess);
        }
        if (recordStats) {
            LOGGER.tracef("Recording Caffeine stats for cache [%s]", (Object)cacheInfo.name);
            this.statsCounter = new ConcurrentStatsCounter();
            builder.recordStats((Supplier)new Supplier<StatsCounter>(){

                @Override
                public StatsCounter get() {
                    return CaffeineCacheImpl.this.statsCounter;
                }
            });
        } else {
            LOGGER.tracef("Caffeine stats recording is disabled for cache [%s]", (Object)cacheInfo.name);
            this.statsCounter = StatsCounter.disabledStatsCounter();
        }
        this.cache = builder.buildAsync();
    }

    @Override
    public String getName() {
        return this.cacheInfo.name;
    }

    @Override
    public <K, V> Uni<V> get(final K key, final Function<K, V> valueLoader) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                CompletableFuture<Object> caffeineValue = CaffeineCacheImpl.this.getFromCaffeine(key, valueLoader);
                return (CompletionStage)CaffeineCacheImpl.this.cast(caffeineValue);
            }
        });
    }

    @Override
    public <V> CompletableFuture<V> getIfPresent(Object key) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        CompletableFuture existingCacheValue = this.cache.getIfPresent(key);
        if (existingCacheValue == null) {
            this.statsCounter.recordMisses(1);
            return null;
        }
        LOGGER.tracef("Key [%s] found in cache [%s]", key, (Object)this.cacheInfo.name);
        this.statsCounter.recordHits(1);
        return this.unwrapCacheValueOrThrowable(existingCacheValue).thenApply(new Function<Object, V>(){

            @Override
            public V apply(Object value) {
                try {
                    return value;
                }
                catch (ClassCastException e) {
                    throw new CacheException("An existing cached value type does not match the requested type", e);
                }
            }
        });
    }

    private <K, V> CompletableFuture<Object> getFromCaffeine(K key, Function<K, V> valueLoader) {
        CompletableFuture<Object> newCacheValue = new CompletableFuture<Object>();
        CompletableFuture<Object> existingCacheValue = this.cache.asMap().putIfAbsent(key, newCacheValue);
        if (existingCacheValue == null) {
            this.statsCounter.recordMisses(1);
            try {
                V value = valueLoader.apply(key);
                newCacheValue.complete(NullValueConverter.toCacheValue(value));
            }
            catch (Throwable t) {
                this.cache.asMap().remove(key, newCacheValue);
                newCacheValue.complete(new CaffeineComputationThrowable(t));
            }
            return this.unwrapCacheValueOrThrowable(newCacheValue);
        }
        LOGGER.tracef("Key [%s] found in cache [%s]", key, (Object)this.cacheInfo.name);
        this.statsCounter.recordHits(1);
        return this.unwrapCacheValueOrThrowable(existingCacheValue);
    }

    private CompletableFuture<Object> unwrapCacheValueOrThrowable(CompletableFuture<Object> cacheValue) {
        return cacheValue.thenApply(new Function<Object, Object>(){

            @Override
            public Object apply(Object value) {
                if (value instanceof CaffeineComputationThrowable) {
                    Throwable cause = ((CaffeineComputationThrowable)value).getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new CacheException(cause);
                }
                return NullValueConverter.fromCacheValue(value);
            }
        });
    }

    @Override
    public Uni<Void> invalidate(final Object key) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().item((Supplier)new Supplier<Void>(){

            @Override
            public Void get() {
                CaffeineCacheImpl.this.cache.synchronous().invalidate(key);
                return null;
            }
        });
    }

    @Override
    public Uni<Void> invalidateAll() {
        return Uni.createFrom().item((Supplier)new Supplier<Void>(){

            @Override
            public Void get() {
                CaffeineCacheImpl.this.cache.synchronous().invalidateAll();
                return null;
            }
        });
    }

    @Override
    public Uni<Void> replaceUniValue(final Object key, final Object emittedValue) {
        return Uni.createFrom().item((Supplier)new Supplier<Void>(){

            @Override
            public Void get() {
                CaffeineCacheImpl.this.cache.asMap().computeIfPresent(key, new BiFunction<Object, CompletableFuture<Object>, CompletableFuture<Object>>(){

                    @Override
                    public CompletableFuture<Object> apply(Object k, CompletableFuture<Object> currentValue) {
                        LOGGER.debugf("Replacing Uni value entry with key [%s] into cache [%s]", key, (Object)CaffeineCacheImpl.this.cacheInfo.name);
                        return CompletableFuture.completedFuture(NullValueConverter.toCacheValue(emittedValue));
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(new HashSet(this.cache.asMap().keySet()));
    }

    @Override
    public <V> void put(Object key, CompletableFuture<V> valueFuture) {
        this.cache.put(key, valueFuture);
    }

    public CaffeineCacheInfo getCacheInfo() {
        return this.cacheInfo;
    }

    public long getSize() {
        return this.cache.synchronous().estimatedSize();
    }

    private <T> T cast(Object value) {
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new CacheException("An existing cached value type does not match the type returned by the value loading function", e);
        }
    }
}

