/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheException;
import io.quarkus.cache.CacheResult;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.quarkus.cache.runtime.UnresolvedUniValue;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheResult(cacheName="")
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);
    private static final String INTERCEPTOR_BINDING_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheResult interceptor binding retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(final InvocationContext invocationContext) throws Throwable {
        CacheInterceptionContext<CacheResult> interceptionContext = this.getInterceptionContext(invocationContext, CacheResult.class, true);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDING_ERROR_MSG);
            return invocationContext.proceed();
        }
        final CacheResult binding = interceptionContext.getInterceptorBindings().get(0);
        AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
        final Object key = this.getCacheKey(cache, interceptionContext.getCacheKeyParameterPositions(), invocationContext.getParameters());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        }
        try {
            Object value;
            Uni<Object> cacheValue = cache.get(key, new Function<Object, Object>(){

                @Override
                public Object apply(Object k) {
                    try {
                        if (Uni.class.isAssignableFrom(invocationContext.getMethod().getReturnType())) {
                            LOGGER.debugf("Adding %s entry with key [%s] into cache [%s]", (Object)UnresolvedUniValue.class.getSimpleName(), key, (Object)binding.cacheName());
                            return UnresolvedUniValue.INSTANCE;
                        }
                        return invocationContext.proceed();
                    }
                    catch (Throwable e) {
                        throw new CacheException(e);
                    }
                }
            });
            if (binding.lockTimeout() <= 0L) {
                value = cacheValue.await().indefinitely();
            } else {
                try {
                    value = cacheValue.await().atMost(Duration.ofMillis(binding.lockTimeout()));
                }
                catch (TimeoutException e) {
                    return invocationContext.proceed();
                }
            }
            if (Uni.class.isAssignableFrom(invocationContext.getMethod().getReturnType())) {
                return this.resolveUni(invocationContext, cache, key, value);
            }
            return value;
        }
        catch (CacheException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    private Object resolveUni(InvocationContext invocationContext, AbstractCache cache, Object key, Object value) throws Exception {
        if (value == UnresolvedUniValue.INSTANCE) {
            return ((Uni)invocationContext.proceed()).onItem().call(emittedValue -> cache.replaceUniValue(key, emittedValue));
        }
        return Uni.createFrom().item(value);
    }
}

