/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheException;
import io.quarkus.cache.CacheInvalidate;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheInvalidate(cacheName="")
@Interceptor
@Priority(value=1)
public class CacheInvalidateInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateInterceptor.class);
    private static final String INTERCEPTOR_BINDINGS_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheInvalidate interceptor bindings retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        CacheInterceptionContext<CacheInvalidate> interceptionContext = this.getInterceptionContext(invocationContext, CacheInvalidate.class, true);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDINGS_ERROR_MSG);
            return invocationContext.proceed();
        }
        CacheInterceptor.ReturnType returnType = CacheInvalidateInterceptor.determineReturnType(invocationContext.getMethod().getReturnType());
        if (returnType == CacheInterceptor.ReturnType.NonAsync) {
            return this.invalidateBlocking(invocationContext, interceptionContext);
        }
        return this.invalidateNonBlocking(invocationContext, interceptionContext, returnType);
    }

    private Object invalidateNonBlocking(final InvocationContext invocationContext, final CacheInterceptionContext<CacheInvalidate> interceptionContext, final CacheInterceptor.ReturnType returnType) {
        LOGGER.trace((Object)"Invalidating cache entries in a non-blocking way");
        Uni uni = Multi.createFrom().iterable(interceptionContext.getInterceptorBindings()).onItem().transformToUniAndMerge((Function)new Function<CacheInvalidate, Uni<? extends Void>>(){

            @Override
            public Uni<Void> apply(CacheInvalidate binding) {
                return CacheInvalidateInterceptor.this.invalidate(binding, interceptionContext.getCacheKeyParameterPositions(), invocationContext.getParameters());
            }
        }).onItem().ignoreAsUni().onItem().transformToUni(new Function<Object, Uni<?>>(){

            @Override
            public Uni<?> apply(Object ignored) {
                try {
                    return CacheInvalidateInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType);
                }
                catch (Exception e) {
                    throw new CacheException(e);
                }
            }
        });
        return this.createAsyncResult((Uni<Object>)uni, returnType);
    }

    private Object invalidateBlocking(InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidate> interceptionContext) throws Exception {
        LOGGER.trace((Object)"Invalidating cache entries in a blocking way");
        for (CacheInvalidate binding : interceptionContext.getInterceptorBindings()) {
            this.invalidate(binding, interceptionContext.getCacheKeyParameterPositions(), invocationContext.getParameters()).await().indefinitely();
        }
        return invocationContext.proceed();
    }

    private Uni<Void> invalidate(CacheInvalidate binding, List<Short> cacheKeyParameterPositions, Object[] parameters) {
        Cache cache = this.cacheManager.getCache(binding.cacheName()).get();
        Object key = this.getCacheKey(cache, cacheKeyParameterPositions, parameters);
        LOGGER.debugf("Invalidating entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        return cache.invalidate(key);
    }
}

