/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache;

import java.util.Arrays;

public class CompositeCacheKey {
    private final Object[] keyElements;

    public CompositeCacheKey(Object ... keyElements) {
        if (keyElements.length == 0) {
            throw new IllegalArgumentException("At least one key element is required to create a composite cache key instance");
        }
        this.keyElements = keyElements;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.keyElements);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (CompositeCacheKey.class.isInstance(obj)) {
            CompositeCacheKey other = (CompositeCacheKey)obj;
            return Arrays.deepEquals(this.keyElements, other.keyElements);
        }
        return false;
    }

    public String toString() {
        return "CompositeCacheKey" + Arrays.toString(this.keyElements);
    }

    public Object[] getKeyElements() {
        return this.keyElements;
    }
}

