/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.RuntimeBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.camel.core.deployment.CamelRuntimeBuildItem;
import io.quarkus.camel.core.deployment.CamelSupport;
import io.quarkus.camel.core.runtime.CamelConfig;
import io.quarkus.camel.core.runtime.CamelProducers;
import io.quarkus.camel.core.runtime.CamelRecorder;
import io.quarkus.camel.core.runtime.CamelRuntime;
import io.quarkus.camel.core.runtime.support.RuntimeRegistry;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Registry;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.slf4j.LoggerFactory;

class CamelInitProcessor {
    @Inject
    ApplicationArchivesBuildItem applicationArchivesBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    CamelConfig.BuildTime buildTimeConfig;

    CamelInitProcessor() {
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(applicationArchiveMarkers={"META-INF/services/org/apache/camel", "org/apache/camel"})
    CamelRuntimeBuildItem createInitTask(RecorderContext recorderContext, CamelRecorder recorder, BuildProducer<RuntimeBeanBuildItem> runtimeBeans) {
        Properties properties = new Properties();
        Config configProvider = ConfigProvider.getConfig();
        for (String property : configProvider.getPropertyNames()) {
            if (property.startsWith("camel.")) {
                properties.put(property, configProvider.getValue(property, String.class));
            }
            if (!property.startsWith("integration.")) continue;
            properties.put(property.substring("integration.".length()), configProvider.getValue(property, String.class));
        }
        RuntimeRegistry registry = new RuntimeRegistry();
        List builders = this.getBuildTimeRouteBuilderClasses().map(arg_0 -> ((RecorderContext)recorderContext).newInstance(arg_0)).collect(Collectors.toList());
        this.visitServices((name, type) -> {
            LoggerFactory.getLogger(CamelInitProcessor.class).debug("Binding camel service {} with type {}", name, type);
            registry.bind(name, type, (Object)recorderContext.newInstance(type.getName()));
        });
        RuntimeValue camelRuntime = recorder.create((Registry)registry, properties, builders);
        runtimeBeans.produce((BuildItem)RuntimeBeanBuildItem.builder(CamelRuntime.class).setRuntimeValue(camelRuntime).build());
        return new CamelRuntimeBuildItem((RuntimeValue<CamelRuntime>)camelRuntime);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(applicationArchiveMarkers={"META-INF/services/org/apache/camel", "org/apache/camel"})
    AdditionalBeanBuildItem createCamelProducers(RecorderContext recorderContext, CamelRuntimeBuildItem runtime, CamelRecorder recorder, BuildProducer<BeanContainerListenerBuildItem> listeners) {
        listeners.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initRuntimeInjection(runtime.getRuntime())));
        return AdditionalBeanBuildItem.unremovableOf(CamelProducers.class);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(applicationArchiveMarkers={"META-INF/services/org/apache/camel", "org/apache/camel"})
    void createInitTask(BeanContainerBuildItem beanContainerBuildItem, CamelRuntimeBuildItem runtime, CamelRecorder recorder) throws Exception {
        recorder.init(beanContainerBuildItem.getValue(), runtime.getRuntime(), this.buildTimeConfig);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(applicationArchiveMarkers={"META-INF/services/org/apache/camel", "org/apache/camel"})
    void createRuntimeInitTask(CamelRecorder recorder, CamelRuntimeBuildItem runtime, ShutdownContextBuildItem shutdown, CamelConfig.Runtime runtimeConfig) throws Exception {
        recorder.start((ShutdownContext)shutdown, runtime.getRuntime(), runtimeConfig);
    }

    protected Stream<String> getBuildTimeRouteBuilderClasses() {
        HashSet allKnownImplementors = new HashSet();
        allKnownImplementors.addAll(this.combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)RoutesBuilder.class.getName())));
        allKnownImplementors.addAll(this.combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)RouteBuilder.class.getName())));
        allKnownImplementors.addAll(this.combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)AdviceWithRouteBuilder.class.getName())));
        return allKnownImplementors.stream().filter(CamelSupport::isConcrete).filter(CamelSupport::isPublic).map(ClassInfo::toString);
    }

    protected void visitServices(BiConsumer<String, Class<?>> consumer) {
        CamelSupport.resources(this.applicationArchivesBuildItem, "META-INF/services/org/apache/camel").forEach(p -> this.visitService((Path)p, consumer));
    }

    protected void visitService(Path p, BiConsumer<String, Class<?>> consumer) {
        String name = p.getFileName().toString();
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(is);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String k = entry.getKey().toString();
                if (!k.equals("class")) continue;
                String clazz = entry.getValue().toString();
                Class<?> cl = Class.forName(clazz);
                consumer.accept(name, cl);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

