/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.camel.core.deployment.CamelSupport;
import io.quarkus.camel.core.runtime.CamelConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBundleBuildItem;
import io.quarkus.jaxb.deployment.JaxbEnabledBuildItem;
import io.quarkus.jaxb.deployment.JaxbFileRootBuildItem;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.camel.Consumer;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory;
import org.apache.camel.spi.ExchangeFormatter;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CamelProcessor {
    private static final List<Class<?>> CAMEL_REFLECTIVE_CLASSES = Arrays.asList(Endpoint.class, Consumer.class, Producer.class, TypeConverter.class, ExchangeFormatter.class, GenericFileProcessStrategy.class);
    private static final List<Class<? extends Annotation>> CAMEL_REFLECTIVE_ANNOTATIONS = Arrays.asList(new Class[0]);
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod;
    @Inject
    BuildProducer<SubstrateResourceBuildItem> resource;
    @Inject
    BuildProducer<SubstrateResourceBundleBuildItem> resourceBundle;
    @Inject
    ApplicationArchivesBuildItem applicationArchivesBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    CamelConfig.BuildTime buildTimeConfig;

    CamelProcessor() {
    }

    @BuildStep
    JaxbFileRootBuildItem fileRoot() {
        return new JaxbFileRootBuildItem("org/apache/camel");
    }

    @BuildStep
    JaxbEnabledBuildItem handleJaxbSupport() {
        return this.buildTimeConfig.disableJaxb ? null : new JaxbEnabledBuildItem();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> handleXmlSupport() {
        if (this.buildTimeConfig.disableXml) {
            return null;
        }
        return Arrays.asList(new ReflectiveClassBuildItem(false, false, new String[]{"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"}), new ReflectiveClassBuildItem(false, false, new String[]{"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl"}), new ReflectiveClassBuildItem(false, false, new String[]{"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl"}));
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("camel-core");
    }

    @BuildStep
    SubstrateConfigBuildItem processSystemProperties() {
        return SubstrateConfigBuildItem.builder().addNativeImageSystemProperty("CamelSimpleLRUCacheFactory", "true").build();
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> configFile() {
        return this.buildTimeConfig.routesUris.stream().map(String::trim).filter(s -> s.startsWith("file:")).map(s -> s.substring("file:".length())).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep(applicationArchiveMarkers={"META-INF/services/org/apache/camel", "org/apache/camel"})
    void process() {
        IndexView view = this.combinedIndexBuildItem.getIndex();
        CAMEL_REFLECTIVE_CLASSES.stream().map(Class::getName).map(DotName::createSimple).map(arg_0 -> ((IndexView)view).getAllKnownImplementors(arg_0)).flatMap(Collection::stream).filter(CamelSupport::isPublic).forEach(v -> this.addReflectiveClass(true, v.name().toString()));
        CAMEL_REFLECTIVE_ANNOTATIONS.stream().map(Class::getName).map(DotName::createSimple).map(arg_0 -> ((IndexView)view).getAnnotations(arg_0)).flatMap(Collection::stream).forEach(v -> {
            if (v.target().kind() == AnnotationTarget.Kind.CLASS) {
                this.addReflectiveClass(true, v.target().asClass().name().toString());
            }
            if (v.target().kind() == AnnotationTarget.Kind.METHOD) {
                this.addReflectiveMethod(v.target().asMethod());
            }
        });
        Logger log = LoggerFactory.getLogger(CamelProcessor.class);
        DotName converter = DotName.createSimple((String)Converter.class.getName());
        List<ClassInfo> converterClasses = view.getAnnotations(converter).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).filter(ai -> {
            boolean isLoader;
            AnnotationValue av = ai.value("loader");
            boolean bl = isLoader = av != null && av.asBoolean();
            if (ai.target().asClass().name().toString().startsWith("org.apache.camel.converter.")) {
                log.debug("Ignoring core " + ai + " " + ai.target().asClass().name());
                return false;
            }
            if (isLoader) {
                log.debug("Ignoring " + ai + " " + ai.target().asClass().name());
                return false;
            }
            log.debug("Accepting " + ai + " " + ai.target().asClass().name());
            return true;
        }).map(ai -> ai.target().asClass()).collect(Collectors.toList());
        log.debug("Converter classes: " + converterClasses);
        converterClasses.forEach(ci -> this.addReflectiveClass(false, ci.name().toString()));
        view.getAnnotations(converter).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD).filter(ai -> converterClasses.contains(ai.target().asMethod().declaringClass())).map(ai -> ai.target().asMethod()).forEach(this::addReflectiveMethod);
        this.addReflectiveClass(false, GenericFile.class.getName());
        this.addReflectiveClass(true, GenericFileProcessStrategyFactory.class.getName());
        CamelSupport.resources(this.applicationArchivesBuildItem, "META-INF/maven/org.apache.camel/camel-core").forEach(this::addResource);
        this.addCamelServices();
    }

    protected void addCamelServices() {
        CamelSupport.resources(this.applicationArchivesBuildItem, "META-INF/services/org/apache/camel").forEach(this::addCamelService);
    }

    protected void addCamelService(Path p) {
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(is);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String k = entry.getKey().toString();
                if (k.equals("class")) {
                    this.addReflectiveClass(true, entry.getValue().toString());
                    continue;
                }
                if (!k.endsWith(".class")) continue;
                this.addReflectiveClass(true, entry.getValue().toString());
                this.addResource(p);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void addResource(Path p) {
        this.addResource(p.toString().substring(1));
    }

    protected void addResource(String r) {
        this.resource.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{r}));
    }

    protected void addReflectiveClass(boolean methods, String ... className) {
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(methods, false, className));
    }

    protected void addReflectiveMethod(MethodInfo mi) {
        this.reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem(mi));
    }

    protected void addResourceBundle(String bundle) {
        this.resourceBundle.produce((BuildItem)new SubstrateResourceBundleBuildItem(bundle));
    }
}

