/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.deployment;

import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jboss.jandex.ClassInfo;

public final class CamelSupport {
    public static final String CAMEL_SERVICE_BASE_PATH = "META-INF/services/org/apache/camel";
    public static final String CAMEL_ROOT_PACKAGE_DIRECTORY = "org/apache/camel";

    private CamelSupport() {
    }

    public static boolean isConcrete(ClassInfo ci) {
        return (ci.flags() & 0x400) == 0;
    }

    public static boolean isPublic(ClassInfo ci) {
        return (ci.flags() & 1) != 0;
    }

    public static Stream<Path> safeWalk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static Stream<Path> resources(ApplicationArchivesBuildItem archives, String path) {
        return archives.getAllApplicationArchives().stream().map(arch -> arch.getArchiveRoot().resolve(path)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(CamelSupport::safeWalk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }
}

