/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.runtime.support;

import io.quarkus.camel.core.runtime.support.FastUuidGenerator;
import io.quarkus.camel.core.runtime.support.NoShutdownStrategy;
import io.quarkus.camel.core.runtime.support.RuntimeSupport;
import java.util.Collection;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.impl.AbstractCamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.UuidGenerator;

public class FastCamelContext
extends DefaultCamelContext {
    public FastCamelContext() {
        super(false);
        this.setInitialization(AbstractCamelContext.Initialization.Eager);
    }

    protected Registry createRegistry() {
        throw new UnsupportedOperationException();
    }

    protected ManagementNameStrategy createManagementNameStrategy() {
        return null;
    }

    protected ShutdownStrategy createShutdownStrategy() {
        return new NoShutdownStrategy();
    }

    protected UuidGenerator createUuidGenerator() {
        return new FastUuidGenerator();
    }

    protected ComponentResolver createComponentResolver() {
        return (name, context) -> this.resolve(Component.class, "component", name, context);
    }

    protected LanguageResolver createLanguageResolver() {
        return (name, context) -> this.resolve(Language.class, "language", name, context);
    }

    protected DataFormatResolver createDataFormatResolver() {
        return new DataFormatResolver(){

            public DataFormat resolveDataFormat(String name, CamelContext context) {
                return this.createDataFormat(name, context);
            }

            public DataFormat createDataFormat(String name, CamelContext context) {
                return FastCamelContext.this.resolve(DataFormat.class, "dataformat", name, context);
            }
        };
    }

    protected <T> T resolve(Class<T> clazz, String type, String name, CamelContext context) {
        Properties props;
        PropertiesComponent comp;
        Object result = context.getRegistry().lookupByNameAndType(name, clazz);
        if (result instanceof CamelContextAware) {
            ((CamelContextAware)result).setCamelContext(context);
        }
        if ((comp = this.getPropertiesComponent()) instanceof org.apache.camel.component.properties.PropertiesComponent && (props = ((org.apache.camel.component.properties.PropertiesComponent)comp).getInitialProperties()) != null) {
            String pfx = "camel." + type + "." + name;
            this.log.debug("Binding {} {} with prefix {}", new Object[]{type, name, pfx});
            RuntimeSupport.bindProperties((CamelContext)this, props, result, pfx);
        }
        return (T)result;
    }

    public void reifyRoutes() throws Exception {
        for (RouteDefinition rd : this.getRouteDefinitions()) {
            this.startRoute(rd);
        }
    }

    protected void startRouteDefinitions(Collection<RouteDefinition> list) throws Exception {
    }

    public void doInit() {
        super.doInit();
        this.forceLazyInitialization();
    }
}

