/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.camel.core.runtime.support;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.camel.core.runtime.CamelConfig;
import io.quarkus.camel.core.runtime.CamelRuntime;
import io.quarkus.camel.core.runtime.InitializedEvent;
import io.quarkus.camel.core.runtime.InitializingEvent;
import io.quarkus.camel.core.runtime.StartedEvent;
import io.quarkus.camel.core.runtime.StartingEvent;
import io.quarkus.camel.core.runtime.StoppedEvent;
import io.quarkus.camel.core.runtime.StoppingEvent;
import io.quarkus.camel.core.runtime.support.FastCamelContext;
import io.quarkus.camel.core.runtime.support.RuntimeSupport;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownableService;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.DefaultModelJAXBContextFactory;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.graalvm.nativeimage.ImageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastCamelRuntime
implements CamelRuntime {
    private static final Logger log = LoggerFactory.getLogger(FastCamelRuntime.class);
    protected CamelContext context;
    protected BeanContainer beanContainer;
    protected Registry registry;
    protected Properties properties;
    protected List<RoutesBuilder> builders;
    protected CamelConfig.BuildTime buildTimeConfig;
    protected CamelConfig.Runtime runtimeConfig;
    protected ModelJAXBContextFactory jaxbContextFactory;

    @Override
    public void init(CamelConfig.BuildTime buildTimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
        if (buildTimeConfig.disableJaxb) {
            this.jaxbContextFactory = () -> {
                throw new UnsupportedOperationException();
            };
        } else {
            this.jaxbContextFactory = new DefaultModelJAXBContextFactory();
            if (ImageInfo.inImageBuildtimeCode()) {
                try {
                    this.jaxbContextFactory.newJAXBContext();
                }
                catch (JAXBException e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
        if (!buildTimeConfig.deferInitPhase) {
            this.doInit();
        }
    }

    @Override
    public void start(CamelConfig.Runtime runtimeConfig) throws Exception {
        this.runtimeConfig = runtimeConfig;
        if (this.buildTimeConfig.deferInitPhase) {
            this.doInit();
        }
        this.doStart();
    }

    @Override
    public void stop() throws Exception {
        this.doStop();
    }

    public void doInit() {
        try {
            this.context = this.createContext();
            RuntimeSupport.bindProperties(this.properties, this.context, "camel.context.");
            this.context.setLoadTypeConverters(Boolean.valueOf(false));
            this.context.setModelJAXBContextFactory(this.jaxbContextFactory);
            PropertiesComponent pc = this.createPropertiesComponent(this.properties);
            RuntimeSupport.bindProperties(pc.getInitialProperties(), pc, "camel.component.properties.");
            this.context.addComponent("properties", (Component)pc);
            this.context.getTypeConverterRegistry().setInjector(this.context.getInjector());
            this.fireEvent(InitializingEvent.class, new InitializingEvent());
            this.context.init();
            this.fireEvent(InitializedEvent.class, new InitializedEvent());
            this.loadRoutes(this.context);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void doStart() throws Exception {
        this.fireEvent(StartingEvent.class, new StartingEvent());
        this.context.start();
        this.fireEvent(StartedEvent.class, new StartedEvent());
        if (this.runtimeConfig.dumpRoutes) {
            this.dumpRoutes();
        }
    }

    protected void doStop() throws Exception {
        this.fireEvent(StoppingEvent.class, new StoppingEvent());
        this.context.stop();
        this.fireEvent(StoppedEvent.class, new StoppedEvent());
        if (this.context instanceof ShutdownableService) {
            ((ShutdownableService)this.context).shutdown();
        }
    }

    protected void loadRoutes(CamelContext context) throws Exception {
        for (RoutesBuilder b : this.builders) {
            context.addRoutes(b);
        }
        List routesUris = this.buildTimeConfig.routesUris.stream().filter(ObjectHelper::isNotEmpty).collect(Collectors.toList());
        if (ObjectHelper.isNotEmpty(routesUris)) {
            log.debug("Loading xml routes from {}", routesUris);
            ModelCamelContext mcc = (ModelCamelContext)context.adapt(ModelCamelContext.class);
            for (String routesUri : routesUris) {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)mcc, (String)routesUri.trim());
                Throwable throwable = null;
                try {
                    mcc.addRouteDefinitions(is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        } else {
            log.debug("No xml routes configured");
        }
        ((FastCamelContext)context.adapt(FastCamelContext.class)).reifyRoutes();
    }

    protected CamelContext createContext() {
        FastCamelContext context = new FastCamelContext();
        context.setRegistry(this.registry);
        return context;
    }

    protected <T> void fireEvent(Class<T> clazz, T event) {
        Arc.container().beanManager().getEvent().select(clazz, new Annotation[0]).fire(event);
    }

    public void setBeanContainer(BeanContainer beanContainer) {
        this.beanContainer = beanContainer;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setBuilders(List<RoutesBuilder> builders) {
        this.builders = builders;
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public CamelConfig.BuildTime getBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    @Override
    public CamelConfig.Runtime getRuntimeConfig() {
        return this.runtimeConfig;
    }

    protected PropertiesComponent createPropertiesComponent(Properties initialPoperties) {
        PropertiesComponent pc = new PropertiesComponent();
        pc.setInitialProperties(initialPoperties);
        RuntimeSupport.bindProperties(this.properties, pc, "camel.component.properties.");
        return pc;
    }

    protected void dumpRoutes() {
        List routes = this.getContext().getRoutes();
        if (routes.isEmpty()) {
            log.info("No route definitions");
        } else {
            log.info("Route definitions:");
            for (Route route : routes) {
                RouteDefinition def = (RouteDefinition)route.getRouteContext().getRoute();
                log.info(def.toString());
            }
        }
    }
}

