/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.EnumAcceptedValues;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import java.text.Normalizer;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.Collectors;

final class AsciidocFormatter {
    private static final String TOOLTIP_MACRO = "tooltip:%s[%s]";
    private static final String MORE_INFO_ABOUT_TYPE_FORMAT = "link:#%s[icon:question-circle[title=More information about the %s format]]";
    private final JavadocRepository javadocRepository;
    private final boolean enableEnumTooltips;

    AsciidocFormatter(JavadocRepository javadocRepository, boolean enableEnumTooltips) {
        this.javadocRepository = javadocRepository;
        this.enableEnumTooltips = enableEnumTooltips;
    }

    String formatDescription(ConfigProperty configProperty) {
        Optional javadocElement = this.javadocRepository.getElement(configProperty.getSourceClass(), configProperty.getSourceName());
        if (javadocElement.isEmpty()) {
            return null;
        }
        String description = ((JavadocElements.JavadocElement)javadocElement.get()).description();
        if (description == null || description.isBlank()) {
            return null;
        }
        return description + "\n\n";
    }

    String formatTypeDescription(ConfigProperty configProperty) {
        Object typeContent = "";
        if (configProperty.isEnum()) {
            typeContent = this.enableEnumTooltips ? configProperty.getEnumAcceptedValues().values().entrySet().stream().map(e -> {
                Optional javadocElement = this.javadocRepository.getElement(configProperty.getType(), (String)e.getKey());
                if (javadocElement.isEmpty()) {
                    return "`" + ((EnumAcceptedValues.EnumAcceptedValue)e.getValue()).configValue() + "`";
                }
                return String.format(TOOLTIP_MACRO, ((EnumAcceptedValues.EnumAcceptedValue)e.getValue()).configValue(), this.cleanTooltipContent(((JavadocElements.JavadocElement)javadocElement.get()).description()));
            }).collect(Collectors.joining(", ")) : configProperty.getEnumAcceptedValues().values().values().stream().map(v -> v.configValue()).collect(Collectors.joining("`, `", "`", "`"));
        } else {
            typeContent = configProperty.getTypeDescription();
            if (configProperty.getJavadocSiteLink() != null) {
                typeContent = String.format("link:%s[%s]", configProperty.getJavadocSiteLink(), typeContent);
            }
        }
        if (configProperty.isList()) {
            typeContent = "list of " + (String)typeContent;
        }
        if (Duration.class.getName().equals(configProperty.getType())) {
            typeContent = (String)typeContent + " " + String.format(MORE_INFO_ABOUT_TYPE_FORMAT, "duration-note-anchor-{summaryTableId}", Duration.class.getSimpleName());
        } else if ("io.quarkus.runtime.configuration.MemorySize".equals(configProperty.getType())) {
            typeContent = (String)typeContent + " " + String.format(MORE_INFO_ABOUT_TYPE_FORMAT, "memory-size-note-anchor-{summaryTableId}", "MemorySize");
        }
        return typeContent;
    }

    String formatDefaultValue(ConfigProperty configProperty) {
        Optional javadocElement;
        Optional<String> enumConstant;
        String defaultValue = configProperty.getDefaultValue();
        if (defaultValue == null) {
            return null;
        }
        if (configProperty.isEnum() && this.enableEnumTooltips && (enumConstant = configProperty.getEnumAcceptedValues().values().entrySet().stream().filter(e -> ((EnumAcceptedValues.EnumAcceptedValue)e.getValue()).configValue().equals(defaultValue)).map(e -> (String)e.getKey()).findFirst()).isPresent() && (javadocElement = this.javadocRepository.getElement(configProperty.getType(), enumConstant.get())).isPresent()) {
            return String.format(TOOLTIP_MACRO, defaultValue, this.cleanTooltipContent(((JavadocElements.JavadocElement)javadocElement.get()).description()));
        }
        return "`" + defaultValue + "`";
    }

    String escapeCellContent(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("|", "\\|");
    }

    String toAnchor(String value) {
        value = Normalizer.normalize(value, Normalizer.Form.NFKC).replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0105\u0103]", "a").replaceAll("[\u00e7\u0107\u010d\u0109\u010b]", "c").replaceAll("[\u010f\u0111\u00f0]", "d").replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0119\u011b\u0115\u0117]", "e").replaceAll("[\u0192\u017f]", "f").replaceAll("[\u011d\u011f\u0121\u0123]", "g").replaceAll("[\u0125\u0127]", "h").replaceAll("[\u00ec\u00ed\u00ee\u00ef\u012b\u0129\u012d\u012f\u0131]", "i").replaceAll("[\u0133\u0135]", "j").replaceAll("[\u0137\u0138]", "k").replaceAll("[\u0142\u013e\u013a\u013c\u0140]", "l").replaceAll("[\u00f1\u0144\u0148\u0146\u0149\u014b]", "n").replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u0151\u014f\u0153]", "o").replaceAll("[\u00de\u00fe]", "p").replaceAll("[\u0155\u0159\u0157]", "r").replaceAll("[\u015b\u0161\u015f\u015d\u0219]", "s").replaceAll("[\u0165\u0163\u0167\u021b]", "t").replaceAll("[\u00f9\u00fa\u00fb\u00fc\u016b\u016f\u0171\u016d\u0169\u0173]", "u").replaceAll("[\u0175]", "w").replaceAll("[\u00fd\u00ff\u0177]", "y").replaceAll("[\u017e\u017c\u017a]", "z").replaceAll("[\u00e6]", "ae").replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0104\u0102]", "A").replaceAll("[\u00c7\u0106\u010c\u0108\u010a]", "C").replaceAll("[\u010e\u0110\u00d0]", "D").replaceAll("[\u00c8\u00c9\u00ca\u00cb\u0112\u0118\u011a\u0114\u0116]", "E").replaceAll("[\u011c\u011e\u0120\u0122]", "G").replaceAll("[\u0124\u0126]", "H").replaceAll("[\u00cc\u00cd\u00ce\u00cf\u012a\u0128\u012c\u012e\u0130]", "I").replaceAll("[\u0134]", "J").replaceAll("[\u0136]", "K").replaceAll("[\u0141\u013d\u0139\u013b\u013f]", "L").replaceAll("[\u00d1\u0143\u0147\u0145\u014a]", "N").replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u0150\u014e]", "O").replaceAll("[\u0154\u0158\u0156]", "R").replaceAll("[\u015a\u0160\u015e\u015c\u0218]", "S").replaceAll("[\u00d9\u00da\u00db\u00dc\u016a\u016e\u0170\u016c\u0168\u0172]", "U").replaceAll("[\u0174]", "W").replaceAll("[\u00dd\u0176\u0178]", "Y").replaceAll("[\u0179\u017d\u017b]", "Z").replaceAll("[\u00df]", "ss");
        value = value.replaceAll("([a-z])'s([^a-z])", "$1s$2");
        value = value.replaceAll("[^\\w-_]", "-").replaceAll("-{2,}", "-");
        value = value.replaceAll("-+$", "").replaceAll("^-+", "");
        return value.toLowerCase();
    }

    String formatSectionTitle(ConfigSection configSection) {
        Optional javadocElement = this.javadocRepository.getElement(configSection.getSourceClass(), configSection.getSourceName());
        if (javadocElement.isEmpty()) {
            throw new IllegalStateException("Couldn't find section title for: " + configSection.getSourceClass() + "#" + configSection.getSourceName());
        }
        String javadoc = ((JavadocElements.JavadocElement)javadocElement.get()).description();
        if (javadoc == null || javadoc.isBlank()) {
            throw new IllegalStateException("Couldn't find section title for: " + configSection.getSourceClass() + "#" + configSection.getSourceName());
        }
        int dotIndex = (javadoc = javadoc.trim()).indexOf(".");
        if (dotIndex == -1) {
            return javadoc;
        }
        return javadoc.substring(0, dotIndex);
    }

    String formatName(Extension extension) {
        if (extension.name() == null) {
            return extension.artifactId();
        }
        return extension.name();
    }

    private String cleanTooltipContent(String tooltipContent) {
        return tooltipContent.replace("<p>", "").replace("</p>", "").replace("\n+\n", " ").replace("\n", " ").replace(":", "\\:").replace("[", "\\]").replace("]", "\\]");
    }
}

