/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocMerger;
import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.merger.MergedModel;
import io.quarkus.annotation.processor.documentation.config.merger.ModelMerger;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigRoot;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.maven.config.doc.AsciidocFormatter;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-asciidoc", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class GenerateAsciidocMojo
extends AbstractMojo {
    private static final String TARGET = "target";
    private static final String ADOC_SUFFIX = ".adoc";
    private static final String CONFIG_ROOT_FILE_FORMAT = "%s_%s.adoc";
    private static final String EXTENSION_FILE_FORMAT = "%s.adoc";
    private static final String ALL_CONFIG_FILE_NAME = "quarkus-all-config.adoc";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter
    private File scanDirectory;
    @Parameter(defaultValue="${project.build.directory}/quarkus-generated-doc/config", required=true)
    private File targetDirectory;
    @Parameter(defaultValue="false")
    private boolean generateAllConfig;
    @Parameter(defaultValue="false")
    private boolean enableEnumTooltips;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String summaryTableId;
        Extension extension;
        if (this.skip) {
            return;
        }
        Path resolvedScanDirectory = this.scanDirectory != null ? this.scanDirectory.toPath() : this.mavenSession.getCurrentProject().getBasedir().toPath().getParent();
        Path resolvedTargetDirectory = this.targetDirectory.toPath();
        GenerateAsciidocMojo.initTargetDirectory(resolvedTargetDirectory);
        List<Path> targetDirectories = GenerateAsciidocMojo.findTargetDirectories(resolvedScanDirectory);
        JavadocRepository javadocRepository = JavadocMerger.mergeJavadocElements(targetDirectories);
        MergedModel mergedModel = ModelMerger.mergeModel(targetDirectories);
        AsciidocFormatter asciidocFormatter = new AsciidocFormatter(javadocRepository, this.enableEnumTooltips);
        Engine quteEngine = GenerateAsciidocMojo.initializeQuteEngine(asciidocFormatter);
        for (Map.Entry extensionConfigRootsEntry : mergedModel.getConfigRoots().entrySet()) {
            extension = (Extension)extensionConfigRootsEntry.getKey();
            Path configRootAdocPath = null;
            for (Map.Entry configRootEntry : ((Map)extensionConfigRootsEntry.getValue()).entrySet()) {
                String topLevelPrefix = (String)configRootEntry.getKey();
                ConfigRoot configRoot = (ConfigRoot)configRootEntry.getValue();
                configRootAdocPath = resolvedTargetDirectory.resolve(String.format(CONFIG_ROOT_FILE_FORMAT, extension.artifactId(), topLevelPrefix));
                String summaryTableId2 = asciidocFormatter.toAnchor(extension.artifactId() + "_" + topLevelPrefix);
                try {
                    Files.writeString(configRootAdocPath, (CharSequence)GenerateAsciidocMojo.generateConfigReference(quteEngine, summaryTableId2, extension, (ConfigItemCollection)configRoot, "", true), new OpenOption[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to render config roots for top level prefix: " + topLevelPrefix + " in extension: " + String.valueOf(extension), e);
                }
            }
            if (((Map)extensionConfigRootsEntry.getValue()).size() != 1 || configRootAdocPath == null) continue;
            Path extensionAdocPath = resolvedTargetDirectory.resolve(String.format(EXTENSION_FILE_FORMAT, extension.artifactId()));
            try {
                Files.copy(configRootAdocPath, extensionAdocPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to copy extension file for: " + String.valueOf(extension), e);
            }
        }
        for (Map.Entry specificFileConfigRootEntry : mergedModel.getConfigRootsInSpecificFile().entrySet()) {
            Object fileName = (String)specificFileConfigRootEntry.getKey();
            ConfigRoot configRoot = (ConfigRoot)specificFileConfigRootEntry.getValue();
            Extension extension2 = configRoot.getExtension();
            if (!((String)fileName).endsWith(ADOC_SUFFIX)) {
                fileName = (String)fileName + ADOC_SUFFIX;
            }
            Path configRootAdocPath = resolvedTargetDirectory.resolve((String)fileName);
            summaryTableId = asciidocFormatter.toAnchor(this.stripAdocSuffix((String)fileName));
            try {
                Files.writeString(configRootAdocPath, (CharSequence)GenerateAsciidocMojo.generateConfigReference(quteEngine, summaryTableId, extension2, (ConfigItemCollection)configRoot, "", true), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to render config roots for specific file: " + (String)fileName + " in extension: " + String.valueOf(extension2), e);
            }
        }
        for (Map.Entry extensionConfigSectionsEntry : mergedModel.getGeneratedConfigSections().entrySet()) {
            extension = (Extension)extensionConfigSectionsEntry.getKey();
            for (ConfigSection generatedConfigSection : (List)extensionConfigSectionsEntry.getValue()) {
                Path configSectionAdocPath = resolvedTargetDirectory.resolve(String.format(CONFIG_ROOT_FILE_FORMAT, extension.artifactId(), GenerateAsciidocMojo.cleanSectionPath(generatedConfigSection.getPath())));
                summaryTableId = asciidocFormatter.toAnchor(extension.artifactId() + "_" + generatedConfigSection.getPath());
                try {
                    Files.writeString(configSectionAdocPath, (CharSequence)GenerateAsciidocMojo.generateConfigReference(quteEngine, summaryTableId, extension, (ConfigItemCollection)generatedConfigSection, "_" + generatedConfigSection.getPath(), false), new OpenOption[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to render config section for section: " + generatedConfigSection.getPath() + " in extension: " + String.valueOf(extension), e);
                }
            }
        }
        if (this.generateAllConfig) {
            try {
                Path allConfigAdocPath = resolvedTargetDirectory.resolve(ALL_CONFIG_FILE_NAME);
                Files.writeString(allConfigAdocPath, (CharSequence)GenerateAsciidocMojo.generateAllConfig(quteEngine, mergedModel.getConfigRoots()), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to render all config", e);
            }
        }
    }

    private static String generateConfigReference(Engine quteEngine, String summaryTableId, Extension extension, ConfigItemCollection configItemCollection, String additionalAnchorPrefix, boolean searchable) {
        return quteEngine.getTemplate("configReference.qute.adoc").data("extension", (Object)extension).data("configItemCollection", (Object)configItemCollection).data("searchable", (Object)searchable).data("summaryTableId", (Object)summaryTableId).data("additionalAnchorPrefix", (Object)additionalAnchorPrefix).data("includeDurationNote", (Object)configItemCollection.hasDurationType()).data("includeMemorySizeNote", (Object)configItemCollection.hasMemorySizeType()).render();
    }

    private static String generateAllConfig(Engine quteEngine, Map<Extension, Map<String, ConfigRoot>> configRootsByExtensions) {
        return quteEngine.getTemplate("allConfig.qute.adoc").data("configRootsByExtensions", configRootsByExtensions).data("searchable", (Object)true).data("summaryTableId", (Object)"all-config").data("additionalAnchorPrefix", (Object)"").data("includeDurationNote", (Object)true).data("includeMemorySizeNote", (Object)true).render();
    }

    private static void initTargetDirectory(Path resolvedTargetDirectory) throws MojoExecutionException {
        try {
            Files.createDirectories(resolvedTargetDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create directory: " + String.valueOf(resolvedTargetDirectory), (Exception)e);
        }
    }

    private static List<Path> findTargetDirectories(Path scanDirectory) throws MojoExecutionException {
        try {
            final ArrayList<Path> targets = new ArrayList<Path>();
            Files.walkFileTree(scanDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.endsWith(GenerateAsciidocMojo.TARGET)) {
                        targets.add(dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            Collections.sort(targets);
            return targets;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to collect the target directories", (Exception)e);
        }
    }

    private static Engine initializeQuteEngine(AsciidocFormatter asciidocFormatter) {
        Engine engine = Engine.builder().addDefaults().addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("configProperty", "configProperty.qute.adoc")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("configSection", "configSection.qute.adoc")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("envVar", "envVar.qute.adoc")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("durationNote", "durationNote.qute.adoc")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("memorySizeNote", "memorySizeNote.qute.adoc")).addValueResolver((ValueResolver)new ReflectionValueResolver()).addValueResolver(ValueResolver.builder().applyToBaseClass(String.class).applyToName("escapeCellContent").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.escapeCellContent((String)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(String.class).applyToName("toAnchor").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.toAnchor((String)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("toAnchor").applyToParameters(2).resolveSync(ctx -> asciidocFormatter.toAnchor(((Extension)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join()).artifactId() + String.valueOf(ctx.evaluate((Expression)ctx.getParams().get(1)).toCompletableFuture().join()) + "_" + ((ConfigProperty)ctx.getBase()).getPath())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigSection.class).applyToName("toAnchor").applyToParameters(2).resolveSync(ctx -> asciidocFormatter.toAnchor(((Extension)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join()).artifactId() + String.valueOf(ctx.evaluate((Expression)ctx.getParams().get(1)).toCompletableFuture().join()) + "_section_" + ((ConfigSection)ctx.getBase()).getPath())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatTypeDescription").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.formatTypeDescription((ConfigProperty)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatDescription").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.formatDescription((ConfigProperty)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatDefaultValue").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.formatDefaultValue((ConfigProperty)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigSection.class).applyToName("formatTitle").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.formatSectionTitle((ConfigSection)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(Extension.class).applyToName("formatName").applyToNoParameters().resolveSync(ctx -> asciidocFormatter.formatName((Extension)ctx.getBase())).build()).build();
        engine.putTemplate("configReference.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/configReference.qute.adoc")));
        engine.putTemplate("allConfig.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/allConfig.qute.adoc")));
        engine.putTemplate("configProperty.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/tags/configProperty.qute.adoc")));
        engine.putTemplate("configSection.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/tags/configSection.qute.adoc")));
        engine.putTemplate("envVar.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/tags/envVar.qute.adoc")));
        engine.putTemplate("durationNote.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/tags/durationNote.qute.adoc")));
        engine.putTemplate("memorySizeNote.qute.adoc", engine.parse(GenerateAsciidocMojo.getTemplate("templates/tags/memorySizeNote.qute.adoc")));
        return engine;
    }

    private static String getTemplate(String template) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
        if (is == null) {
            throw new IllegalArgumentException("Template does not exist: " + template);
        }
        try {
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read the template: " + template, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable close InputStream for template: " + template, e);
            }
        }
    }

    private static String cleanSectionPath(String sectionPath) {
        return sectionPath.replace('\"', '-');
    }

    private String stripAdocSuffix(String fileName) {
        return fileName.substring(0, fileName.length() - ADOC_SUFFIX.length());
    }
}

