/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc.generator;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.merger.MergedModel;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.maven.config.doc.GenerateConfigDocMojo;
import io.quarkus.maven.config.doc.generator.AsciidocFormatter;
import io.quarkus.maven.config.doc.generator.Format;
import io.quarkus.maven.config.doc.generator.GenerationReport;
import io.quarkus.maven.config.doc.generator.MarkdownFormatter;

public interface Formatter {
    public boolean displayConfigRootDescription(MergedModel.ConfigRootKey var1, int var2);

    public String formatDescription(ConfigProperty var1);

    default public String formatDescription(ConfigProperty configProperty, Extension extension, GenerateConfigDocMojo.Context context) {
        return this.formatDescription(configProperty);
    }

    public String formatTypeDescription(ConfigProperty var1, GenerateConfigDocMojo.Context var2);

    public String formatDefaultValue(ConfigProperty var1);

    public int adjustedLevel(ConfigSection var1, boolean var2);

    public String escapeCellContent(String var1);

    public String toAnchor(String var1);

    public String formatSectionTitle(ConfigSection var1);

    public String formatName(Extension var1);

    public static Formatter getFormatter(GenerationReport generationReport, JavadocRepository javadocRepository, boolean enableEnumTooltips, Format format) {
        switch (format) {
            case asciidoc: {
                return new AsciidocFormatter(generationReport, javadocRepository, enableEnumTooltips);
            }
            case markdown: {
                return new MarkdownFormatter(generationReport, javadocRepository);
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + format);
    }
}

