/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocMerger;
import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.merger.MergedModel;
import io.quarkus.annotation.processor.documentation.config.merger.ModelMerger;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigRoot;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.maven.config.doc.generator.Format;
import io.quarkus.maven.config.doc.generator.Formatter;
import io.quarkus.maven.config.doc.generator.GenerationReport;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-config-doc", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class GenerateConfigDocMojo
extends AbstractMojo {
    private static final String TARGET = "target";
    private static final String ADOC_SUFFIX = ".adoc";
    private static final String CONFIG_ROOT_FILE_FORMAT = "%s_%s.%s";
    private static final String EXTENSION_FILE_FORMAT = "%s.%s";
    private static final String ALL_CONFIG_FILE_FORMAT = "quarkus-all-config.%s";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="asciidoc")
    private String format;
    @Parameter(defaultValue="default")
    private String theme;
    @Parameter
    private File scanDirectory;
    @Parameter(defaultValue="${project.build.directory}/quarkus-generated-doc/config", required=true)
    private File targetDirectory;
    @Parameter(defaultValue="false")
    private boolean generateAllConfig;
    @Parameter(defaultValue="false")
    private boolean enableEnumTooltips;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Context context;
        String summaryTableId;
        if (this.skip) {
            return;
        }
        Path resolvedScanDirectory = this.scanDirectory != null ? this.scanDirectory.toPath() : this.mavenSession.getCurrentProject().getBasedir().toPath().getParent();
        Path resolvedTargetDirectory = this.targetDirectory.toPath();
        GenerateConfigDocMojo.initTargetDirectory(resolvedTargetDirectory);
        List<Path> targetDirectories = GenerateConfigDocMojo.findTargetDirectories(resolvedScanDirectory);
        GenerationReport generationReport = new GenerationReport();
        JavadocRepository javadocRepository = JavadocMerger.mergeJavadocElements(targetDirectories);
        MergedModel mergedModel = ModelMerger.mergeModel((JavadocRepository)javadocRepository, targetDirectories, (boolean)true);
        Format normalizedFormat = Format.normalizeFormat(this.format);
        String normalizedTheme = normalizedFormat.normalizeTheme(this.theme);
        Formatter formatter = Formatter.getFormatter(generationReport, javadocRepository, this.enableEnumTooltips, normalizedFormat);
        Engine quteEngine = GenerateConfigDocMojo.initializeQuteEngine(formatter, normalizedFormat, normalizedTheme);
        for (Map.Entry entry : mergedModel.getConfigRoots().entrySet()) {
            Extension extension = (Extension)entry.getKey();
            Path configRootPath = null;
            for (Map.Entry configRootEntry : ((Map)entry.getValue()).entrySet()) {
                String topLevelPrefix = ((MergedModel.ConfigRootKey)configRootEntry.getKey()).topLevelPrefix();
                ConfigRoot configRoot = (ConfigRoot)configRootEntry.getValue();
                configRootPath = resolvedTargetDirectory.resolve(String.format(CONFIG_ROOT_FILE_FORMAT, extension.artifactId(), topLevelPrefix, normalizedFormat.getExtension()));
                summaryTableId = formatter.toAnchor(extension.artifactId() + "_" + topLevelPrefix);
                context = new Context(summaryTableId, false);
                try {
                    Files.writeString(configRootPath, (CharSequence)GenerateConfigDocMojo.generateConfigReference(quteEngine, context, extension, (ConfigItemCollection)configRoot, "", true), new OpenOption[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to render config roots for top level prefix: " + topLevelPrefix + " in extension: " + extension, e);
                }
            }
            if (((Map)entry.getValue()).size() != 1 || configRootPath == null) continue;
            Path extensionPath = resolvedTargetDirectory.resolve(String.format(EXTENSION_FILE_FORMAT, extension.artifactId(), normalizedFormat.getExtension()));
            try {
                Files.copy(configRootPath, extensionPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to copy extension file for: " + extension, e);
            }
        }
        for (Map.Entry entry : mergedModel.getConfigRootsInSpecificFile().entrySet()) {
            String string = (String)entry.getKey();
            ConfigRoot configRoot = (ConfigRoot)entry.getValue();
            Extension extension2 = configRoot.getExtension();
            if (configRoot.getNonDeprecatedItems().isEmpty()) continue;
            String normalizedFileName = this.stripAdocSuffix(string);
            String fileName = normalizedFileName + "." + normalizedFormat.getExtension();
            Path configRootPath = resolvedTargetDirectory.resolve(fileName);
            summaryTableId = formatter.toAnchor(normalizedFileName);
            context = new Context(summaryTableId, false);
            try {
                Files.writeString(configRootPath, (CharSequence)GenerateConfigDocMojo.generateConfigReference(quteEngine, context, extension2, (ConfigItemCollection)configRoot, "", true), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to render config roots for specific file: " + fileName + " in extension: " + extension2, e);
            }
        }
        if (!generationReport.getViolations().isEmpty()) {
            StringBuilder report = new StringBuilder("One or more errors happened during the configuration documentation generation. Here is a full report:\n\n");
            for (Map.Entry<String, List<GenerationReport.GenerationViolation>> entry : generationReport.getViolations().entrySet()) {
                report.append("- ").append(entry.getKey()).append("\n");
                for (GenerationReport.GenerationViolation violation : entry.getValue()) {
                    report.append("    . ").append(violation.sourceElement()).append(" - ").append(violation.message()).append("\n");
                }
                report.append("\n----\n\n");
            }
            throw new IllegalStateException(report.toString());
        }
        for (Map.Entry entry : mergedModel.getGeneratedConfigSections().entrySet()) {
            Extension extension = (Extension)entry.getKey();
            for (ConfigSection generatedConfigSection : (List)entry.getValue()) {
                if (generatedConfigSection.getNonDeprecatedItems().isEmpty()) continue;
                Path configSectionPath = resolvedTargetDirectory.resolve(String.format(CONFIG_ROOT_FILE_FORMAT, extension.artifactId(), GenerateConfigDocMojo.cleanSectionPath(generatedConfigSection.getPath().property()), normalizedFormat.getExtension()));
                String summaryTableId2 = formatter.toAnchor(extension.artifactId() + "_" + generatedConfigSection.getPath().property());
                Context context2 = new Context(summaryTableId2, false);
                try {
                    Files.writeString(configSectionPath, (CharSequence)GenerateConfigDocMojo.generateConfigReference(quteEngine, context2, extension, (ConfigItemCollection)generatedConfigSection, "_" + generatedConfigSection.getPath().property(), false), new OpenOption[0]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to render config section for section: " + generatedConfigSection.getPath().property() + " in extension: " + extension, e);
                }
            }
        }
        if (this.generateAllConfig) {
            try {
                Path allConfigPath = resolvedTargetDirectory.resolve(String.format(ALL_CONFIG_FILE_FORMAT, normalizedFormat.getExtension()));
                Context context2 = new Context("all-config", true);
                Files.writeString(allConfigPath, (CharSequence)GenerateConfigDocMojo.generateAllConfig(quteEngine, context2, mergedModel.getConfigRoots()), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to render all config", e);
            }
        }
    }

    private static String generateConfigReference(Engine quteEngine, Context context, Extension extension, ConfigItemCollection configItemCollection, String additionalAnchorPrefix, boolean searchable) {
        return quteEngine.getTemplate("configReference").data("extension", (Object)extension).data("configItemCollection", (Object)configItemCollection).data("searchable", (Object)searchable).data("context", (Object)context).data("summaryTableId", (Object)context.summaryTableId()).data("additionalAnchorPrefix", (Object)additionalAnchorPrefix).data("includeDurationNote", (Object)configItemCollection.hasDurationType()).data("includeMemorySizeNote", (Object)configItemCollection.hasMemorySizeType()).render();
    }

    private static String generateAllConfig(Engine quteEngine, Context context, Map<Extension, Map<MergedModel.ConfigRootKey, ConfigRoot>> configRootsByExtensions) {
        return quteEngine.getTemplate("allConfig").data("configRootsByExtensions", configRootsByExtensions).data("searchable", (Object)true).data("context", (Object)context).data("summaryTableId", (Object)context.summaryTableId()).data("additionalAnchorPrefix", (Object)"").data("includeDurationNote", (Object)true).data("includeMemorySizeNote", (Object)true).render();
    }

    private static void initTargetDirectory(Path resolvedTargetDirectory) throws MojoExecutionException {
        try {
            Files.createDirectories(resolvedTargetDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create directory: " + resolvedTargetDirectory, (Exception)e);
        }
    }

    private static List<Path> findTargetDirectories(Path scanDirectory) throws MojoExecutionException {
        try {
            final ArrayList<Path> targets = new ArrayList<Path>();
            Files.walkFileTree(scanDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.endsWith(GenerateConfigDocMojo.TARGET)) {
                        targets.add(dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            Collections.sort(targets);
            return targets;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to collect the target directories", (Exception)e);
        }
    }

    private static Engine initializeQuteEngine(Formatter formatter, Format format, String theme) {
        Engine engine = Engine.builder().addDefaults().addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("configProperty", "configProperty")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("configSection", "configSection")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("envVar", "envVar")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("durationNote", "durationNote")).addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory("memorySizeNote", "memorySizeNote")).addValueResolver((ValueResolver)new ReflectionValueResolver()).addValueResolver(ValueResolver.builder().applyToBaseClass(String.class).applyToName("escapeCellContent").applyToNoParameters().resolveSync(ctx -> formatter.escapeCellContent((String)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(String.class).applyToName("toAnchor").applyToNoParameters().resolveSync(ctx -> formatter.toAnchor((String)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(MergedModel.ConfigRootKey.class).applyToName("displayConfigRootDescription").applyToParameters(1).resolveSync(ctx -> formatter.displayConfigRootDescription((MergedModel.ConfigRootKey)ctx.getBase(), (Integer)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("toAnchor").applyToParameters(2).resolveSync(ctx -> formatter.toAnchor(((Extension)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join()).artifactId() + ctx.evaluate((Expression)ctx.getParams().get(1)).toCompletableFuture().join() + "_" + ((ConfigProperty)ctx.getBase()).getPath().property())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigSection.class).applyToName("toAnchor").applyToParameters(2).resolveSync(ctx -> formatter.toAnchor(((Extension)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join()).artifactId() + ctx.evaluate((Expression)ctx.getParams().get(1)).toCompletableFuture().join() + "_section_" + ((ConfigSection)ctx.getBase()).getPath().property())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatTypeDescription").applyToParameters(1).resolveSync(ctx -> formatter.formatTypeDescription((ConfigProperty)ctx.getBase(), (Context)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatTypeDescription").applyToNoParameters().resolveSync(ctx -> formatter.formatTypeDescription((ConfigProperty)ctx.getBase(), null)).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatDescription").applyToNoParameters().resolveSync(ctx -> formatter.formatDescription((ConfigProperty)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatDescription").applyToParameters(2).resolveSync(ctx -> formatter.formatDescription((ConfigProperty)ctx.getBase(), (Extension)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join(), (Context)ctx.evaluate((Expression)ctx.getParams().get(1)).toCompletableFuture().join())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigProperty.class).applyToName("formatDefaultValue").applyToNoParameters().resolveSync(ctx -> formatter.formatDefaultValue((ConfigProperty)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigSection.class).applyToName("formatTitle").applyToNoParameters().resolveSync(ctx -> formatter.formatSectionTitle((ConfigSection)ctx.getBase())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(ConfigSection.class).applyToName("adjustedLevel").applyToParameters(1).resolveSync(ctx -> formatter.adjustedLevel((ConfigSection)ctx.getBase(), (Boolean)ctx.evaluate((Expression)ctx.getParams().get(0)).toCompletableFuture().join())).build()).addValueResolver(ValueResolver.builder().applyToBaseClass(Extension.class).applyToName("formatName").applyToNoParameters().resolveSync(ctx -> formatter.formatName((Extension)ctx.getBase())).build()).build();
        engine.putTemplate("configReference", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "configReference", false)));
        engine.putTemplate("allConfig", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "allConfig", false)));
        engine.putTemplate("configProperty", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "configProperty", true)));
        engine.putTemplate("configSection", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "configSection", true)));
        engine.putTemplate("envVar", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "envVar", true)));
        engine.putTemplate("durationNote", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "durationNote", true)));
        engine.putTemplate("memorySizeNote", engine.parse(GenerateConfigDocMojo.getTemplate("templates", format, theme, "memorySizeNote", true)));
        return engine;
    }

    private static String getTemplate(String root, Format format, String theme, String template, boolean tag) {
        ArrayList<CallSite> candidates = new ArrayList<CallSite>();
        candidates.add((CallSite)((Object)(root + "/" + format + "/" + theme + "/" + (tag ? "tags/" : "") + template + ".qute." + format.getExtension())));
        if (!"default".equals(theme)) {
            candidates.add((CallSite)((Object)(root + "/" + format + "/default/" + (tag ? "tags/" : "") + template + ".qute." + format.getExtension())));
        }
        InputStream is = null;
        for (String string : candidates) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (is == null) continue;
            break;
        }
        if (is == null) {
            throw new IllegalArgumentException("Unable to find a template for these candidates " + candidates);
        }
        try {
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read the template: " + template, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to close InputStream for template: " + template, e);
            }
        }
    }

    private static String cleanSectionPath(String sectionPath) {
        return sectionPath.replace('\"', '-');
    }

    private String stripAdocSuffix(String fileName) {
        return fileName.substring(0, fileName.length() - ADOC_SUFFIX.length());
    }

    public record Context(String summaryTableId, boolean allConfig) {
    }
}

