/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc.generator;

import io.quarkus.annotation.processor.documentation.config.formatter.JavadocTransformer;
import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.merger.MergedModel;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.EnumAcceptedValues;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.model.JavadocFormat;
import io.quarkus.maven.config.doc.GenerateConfigDocMojo;
import io.quarkus.maven.config.doc.generator.Formatter;
import io.quarkus.maven.config.doc.generator.GenerationReport;
import java.text.Normalizer;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class AbstractFormatter
implements Formatter {
    protected final GenerationReport generationReport;
    protected final JavadocRepository javadocRepository;
    protected final boolean enableEnumTooltips;

    AbstractFormatter(GenerationReport generationReport, JavadocRepository javadocRepository, boolean enableEnumTooltips) {
        this.generationReport = generationReport;
        this.javadocRepository = javadocRepository;
        this.enableEnumTooltips = enableEnumTooltips;
    }

    @Override
    public boolean displayConfigRootDescription(MergedModel.ConfigRootKey configRootKey, int mapSize) {
        if (mapSize <= 1) {
            return false;
        }
        return configRootKey.description() != null;
    }

    @Override
    public String formatDescription(ConfigProperty configProperty) {
        Optional javadocElement = this.javadocRepository.getElement(configProperty.getSourceType(), configProperty.getSourceElementName());
        if (javadocElement.isEmpty()) {
            this.generationReport.addError(new GenerationReport.ConfigPropertyGenerationViolation(configProperty.getSourceType(), configProperty.getSourceElementName(), configProperty.getSourceElementType(), "Missing Javadoc"));
            return null;
        }
        String description = JavadocTransformer.transform((String)((JavadocElements.JavadocElement)javadocElement.get()).description(), (JavadocFormat)((JavadocElements.JavadocElement)javadocElement.get()).format(), (JavadocFormat)this.javadocFormat());
        if (description == null || description.isBlank()) {
            this.generationReport.addError(new GenerationReport.ConfigPropertyGenerationViolation(configProperty.getSourceType(), configProperty.getSourceElementName(), configProperty.getSourceElementType(), "Transformed Javadoc is empty"));
            return null;
        }
        return description + "\n\n";
    }

    @Override
    public String formatTypeDescription(ConfigProperty configProperty, GenerateConfigDocMojo.Context context) {
        Object typeContent = "";
        if (configProperty.isEnum()) {
            typeContent = this.enableEnumTooltips ? configProperty.getEnumAcceptedValues().values().entrySet().stream().map(e -> {
                Optional javadocElement = this.javadocRepository.getElement(configProperty.getType(), (String)e.getKey());
                if (javadocElement.isEmpty()) {
                    return "`" + ((EnumAcceptedValues.EnumAcceptedValue)e.getValue()).configValue() + "`";
                }
                return this.tooltip(((EnumAcceptedValues.EnumAcceptedValue)e.getValue()).configValue(), JavadocTransformer.transform((String)((JavadocElements.JavadocElement)javadocElement.get()).description(), (JavadocFormat)((JavadocElements.JavadocElement)javadocElement.get()).format(), (JavadocFormat)this.javadocFormat()));
            }).collect(Collectors.joining(", ")) : configProperty.getEnumAcceptedValues().values().values().stream().map(v -> v.configValue()).collect(Collectors.joining("`, `", "`", "`"));
        } else {
            typeContent = configProperty.getTypeDescription();
            if (configProperty.getJavadocSiteLink() != null) {
                typeContent = this.link(configProperty.getJavadocSiteLink(), (String)typeContent);
            }
        }
        if (configProperty.isList()) {
            typeContent = "list of " + (String)typeContent;
        }
        if (Duration.class.getName().equals(configProperty.getType())) {
            typeContent = (String)typeContent + "\u00a0" + this.moreInformationAboutType(context, "duration-note-anchor", Duration.class.getSimpleName());
        } else if ("io.quarkus.runtime.configuration.MemorySize".equals(configProperty.getType())) {
            typeContent = (String)typeContent + "\u00a0" + this.moreInformationAboutType(context, "memory-size-note-anchor", "MemorySize");
        }
        return typeContent;
    }

    @Override
    public String formatDefaultValue(ConfigProperty configProperty) {
        Optional javadocElement;
        Optional<String> enumConstant;
        String defaultValue = configProperty.getDefaultValue();
        if (defaultValue == null) {
            return null;
        }
        if (configProperty.isEnum() && this.enableEnumTooltips && (enumConstant = configProperty.getEnumAcceptedValues().values().entrySet().stream().filter(e -> ((EnumAcceptedValues.EnumAcceptedValue)e.getValue()).configValue().equals(defaultValue)).map(e -> (String)e.getKey()).findFirst()).isPresent() && (javadocElement = this.javadocRepository.getElement(configProperty.getType(), enumConstant.get())).isPresent()) {
            return this.tooltip(defaultValue, ((JavadocElements.JavadocElement)javadocElement.get()).description());
        }
        return "`" + defaultValue + "`";
    }

    @Override
    public int adjustedLevel(ConfigSection configSection, boolean multiRoot) {
        if (multiRoot) {
            return configSection.getLevel() + 1;
        }
        return configSection.getLevel();
    }

    @Override
    public String escapeCellContent(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("|", "\\|");
    }

    @Override
    public String toAnchor(String value) {
        value = Normalizer.normalize(value, Normalizer.Form.NFKC).replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0105\u0103]", "a").replaceAll("[\u00e7\u0107\u010d\u0109\u010b]", "c").replaceAll("[\u010f\u0111\u00f0]", "d").replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0119\u011b\u0115\u0117]", "e").replaceAll("[\u0192\u017f]", "f").replaceAll("[\u011d\u011f\u0121\u0123]", "g").replaceAll("[\u0125\u0127]", "h").replaceAll("[\u00ec\u00ed\u00ee\u00ef\u012b\u0129\u012d\u012f\u0131]", "i").replaceAll("[\u0133\u0135]", "j").replaceAll("[\u0137\u0138]", "k").replaceAll("[\u0142\u013e\u013a\u013c\u0140]", "l").replaceAll("[\u00f1\u0144\u0148\u0146\u0149\u014b]", "n").replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u0151\u014f\u0153]", "o").replaceAll("[\u00de\u00fe]", "p").replaceAll("[\u0155\u0159\u0157]", "r").replaceAll("[\u015b\u0161\u015f\u015d\u0219]", "s").replaceAll("[\u0165\u0163\u0167\u021b]", "t").replaceAll("[\u00f9\u00fa\u00fb\u00fc\u016b\u016f\u0171\u016d\u0169\u0173]", "u").replaceAll("[\u0175]", "w").replaceAll("[\u00fd\u00ff\u0177]", "y").replaceAll("[\u017e\u017c\u017a]", "z").replaceAll("[\u00e6]", "ae").replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0104\u0102]", "A").replaceAll("[\u00c7\u0106\u010c\u0108\u010a]", "C").replaceAll("[\u010e\u0110\u00d0]", "D").replaceAll("[\u00c8\u00c9\u00ca\u00cb\u0112\u0118\u011a\u0114\u0116]", "E").replaceAll("[\u011c\u011e\u0120\u0122]", "G").replaceAll("[\u0124\u0126]", "H").replaceAll("[\u00cc\u00cd\u00ce\u00cf\u012a\u0128\u012c\u012e\u0130]", "I").replaceAll("[\u0134]", "J").replaceAll("[\u0136]", "K").replaceAll("[\u0141\u013d\u0139\u013b\u013f]", "L").replaceAll("[\u00d1\u0143\u0147\u0145\u014a]", "N").replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u0150\u014e]", "O").replaceAll("[\u0154\u0158\u0156]", "R").replaceAll("[\u015a\u0160\u015e\u015c\u0218]", "S").replaceAll("[\u00d9\u00da\u00db\u00dc\u016a\u016e\u0170\u016c\u0168\u0172]", "U").replaceAll("[\u0174]", "W").replaceAll("[\u00dd\u0176\u0178]", "Y").replaceAll("[\u0179\u017d\u017b]", "Z").replaceAll("[\u00df]", "ss");
        value = value.replaceAll("([a-z])'s([^a-z])", "$1s$2");
        value = value.replaceAll("[^\\w-_]", "-").replaceAll("-{2,}", "-");
        value = value.replaceAll("-+$", "").replaceAll("^-+", "");
        return value.toLowerCase();
    }

    @Override
    public String formatSectionTitle(ConfigSection configSection) {
        Optional javadocElement = this.javadocRepository.getElement(configSection.getSourceType(), configSection.getSourceElementName());
        if (javadocElement.isEmpty()) {
            this.generationReport.addError(new GenerationReport.ConfigPropertyGenerationViolation(configSection.getSourceType(), configSection.getSourceElementName(), configSection.getSourceElementType(), "Missing Javadoc"));
            return null;
        }
        String javadoc = JavadocTransformer.transform((String)((JavadocElements.JavadocElement)javadocElement.get()).description(), (JavadocFormat)((JavadocElements.JavadocElement)javadocElement.get()).format(), (JavadocFormat)this.javadocFormat());
        if (javadoc == null || javadoc.isBlank()) {
            this.generationReport.addError(new GenerationReport.ConfigPropertyGenerationViolation(configSection.getSourceType(), configSection.getSourceElementName(), configSection.getSourceElementType(), "Transformed Javadoc is empty"));
            return null;
        }
        return AbstractFormatter.trimFinalDot(javadoc);
    }

    @Override
    public String formatName(Extension extension) {
        if (extension.name() == null) {
            return extension.artifactId();
        }
        return extension.name();
    }

    private static String trimFinalDot(String javadoc) {
        if (javadoc == null || javadoc.isBlank()) {
            return null;
        }
        int dotIndex = (javadoc = javadoc.trim()).indexOf(".");
        if (dotIndex == -1) {
            return javadoc;
        }
        return javadoc.substring(0, dotIndex);
    }

    protected abstract JavadocFormat javadocFormat();

    protected abstract String moreInformationAboutType(GenerateConfigDocMojo.Context var1, String var2, String var3);

    protected abstract String link(String var1, String var2);

    protected abstract String tooltip(String var1, String var2);
}

