/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.yaml.runtime;

import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.Converter;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public abstract class AbstractYamlObjectConverter<T>
implements Converter<T> {
    protected abstract Class<T> getClazz();

    protected Map<String, String> getFieldNameMap() {
        return Collections.emptyMap();
    }

    public T convert(String value) {
        Constructor constructor = new Constructor();
        CustomPropertyUtils propertyUtils = new CustomPropertyUtils(this.getFieldNameMap());
        propertyUtils.setSkipMissingProperties(true);
        constructor.setPropertyUtils((PropertyUtils)propertyUtils);
        return (T)new Yaml((BaseConstructor)constructor).loadAs(value, this.getClazz());
    }

    private static class CustomPropertyUtils
    extends PropertyUtils {
        private final Map<String, String> fieldNameMap;

        public CustomPropertyUtils(Map<String, String> fieldNameMap) {
            this.fieldNameMap = fieldNameMap;
        }

        public Property getProperty(Class<?> type, String name) {
            if (this.fieldNameMap.containsKey(name)) {
                name = this.fieldNameMap.get(name);
            }
            return super.getProperty(type, name);
        }
    }
}

