/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.yaml.runtime;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class ApplicationYamlConfigSourceLoader
extends AbstractLocationConfigSourceLoader {
    protected String[] getFileExtensions() {
        return new String[]{"yaml", "yml"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new YamlConfigSource(url, ordinal);
    }

    public static class InFileSystem
    extends ApplicationYamlConfigSourceLoader
    implements ConfigSourceProvider {
        @Override
        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            return super.loadConfigSource(url, 265);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            configSources.addAll(this.loadConfigSources("config/application.yaml", classLoader));
            configSources.addAll(this.loadConfigSources("config/application.yml", classLoader));
            return configSources;
        }

        protected List<ConfigSource> tryClassPath(URI uri, ClassLoader classLoader) {
            return new ArrayList<ConfigSource>();
        }
    }

    public static class InClassPath
    extends ApplicationYamlConfigSourceLoader
    implements ConfigSourceProvider {
        @Override
        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            return super.loadConfigSource(url, 255);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            configSources.addAll(this.loadConfigSources("application.yaml", classLoader));
            configSources.addAll(this.loadConfigSources("application.yml", classLoader));
            return configSources;
        }

        protected List<ConfigSource> tryFileSystem(URI uri) {
            return new ArrayList<ConfigSource>();
        }
    }
}

