/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.confluent.registry.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.confluent.kafka.schemaregistry.annotations.Schema;
import io.confluent.kafka.schemaregistry.annotations.SchemaReference;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@TargetClass(className="io.confluent.kafka.schemaregistry.json.JsonSchemaUtils")
final class Target_io_confluent_kafka_schemaregistry_json_JsonSchemaUtils {
    Target_io_confluent_kafka_schemaregistry_json_JsonSchemaUtils() {
    }

    @Substitute
    public static JsonSchema getSchema(Object object, SpecificationVersion specVersion, boolean useOneofForNullables, boolean failUnknownProperties, ObjectMapper objectMapper, SchemaRegistryClient client) throws IOException {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        if (cls.isAnnotationPresent(Schema.class)) {
            final Schema schema = cls.getAnnotation(Schema.class);
            final List references = Arrays.stream(schema.refs()).map(new Function<SchemaReference, io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference>(){

                @Override
                public io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference apply(SchemaReference schemaReference) {
                    return new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference(schemaReference.name(), schemaReference.subject(), Integer.valueOf(schemaReference.version()));
                }
            }).collect(Collectors.toList());
            if (client == null) {
                if (!references.isEmpty()) {
                    throw new IllegalArgumentException("Cannot resolve schema " + schema.value() + " with refs " + references);
                }
                return new JsonSchema(schema.value());
            }
            return (JsonSchema)client.parseSchema("JSON", schema.value(), references).orElseThrow(new Supplier<IOException>(){

                @Override
                public IOException get() {
                    return new IOException("Invalid schema " + schema.value() + " with refs " + references);
                }
            });
        }
        return null;
    }
}

