/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ContainerProcessor {
    private static final Map<String, String> CAPABILITY_TO_EXTENSION_NAME = new HashMap<String, String>();

    @BuildStep
    public ContainerImageInfoBuildItem publishImageInfo(ApplicationInfoBuildItem app, ContainerImageConfig containerImageConfig, Capabilities capabilities) {
        this.ensureSingleContainerImageExtension(capabilities);
        return new ContainerImageInfoBuildItem(containerImageConfig.registry, containerImageConfig.group, containerImageConfig.name.orElse(app.getName()), containerImageConfig.tag.orElse(app.getVersion()));
    }

    private void ensureSingleContainerImageExtension(Capabilities capabilities) {
        HashSet<String> activeContainerImageCapabilities = new HashSet<String>();
        for (String capability : capabilities.getCapabilities()) {
            if (!capability.toLowerCase().contains("container-image")) continue;
            if (!CAPABILITY_TO_EXTENSION_NAME.containsKey(capability)) {
                throw new IllegalArgumentException("Unknown container-image capability: " + capability);
            }
            activeContainerImageCapabilities.add(CAPABILITY_TO_EXTENSION_NAME.get(capability));
        }
        if (activeContainerImageCapabilities.size() > 1) {
            throw new IllegalStateException(String.join((CharSequence)" and ", activeContainerImageCapabilities) + " were detected, at most one container-image extension can be present. ");
        }
    }

    static {
        CAPABILITY_TO_EXTENSION_NAME.put("io.quarkus.container-image-jib", "quarkus-container-image-jib");
        CAPABILITY_TO_EXTENSION_NAME.put("io.quarkus.container-image-docker", "quarkus-container-image-docker");
        CAPABILITY_TO_EXTENSION_NAME.put("io.quarkus.container-image-s2i", "quarkus-container-image-s2i");
    }
}

