package io.quarkus.container.image.deployment;

import java.util.Optional;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;

@ConfigRoot
public class ContainerImageConfig {

    /**
     * The group the container image will be part of
     */
    @ConfigItem(defaultValue = "${user.name}")
    public Optional<String> group;

    /**
     * The name of the container image. If not set defaults to the application name
     */
    @ConfigItem(defaultValue = "${quarkus.application.name:unset}")
    public Optional<String> name;

    /**
     * The tag of the container image. If not set defaults to the application version
     */
    @ConfigItem(defaultValue = "${quarkus.application.version:latest}")
    public Optional<String> tag;

    /**
     * The container registry to use
     */
    @ConfigItem
    public Optional<String> registry;

    /**
     * The username to use to authenticate with the registry where the built image will be pushed
     */
    @ConfigItem
    public Optional<String> username;

    /**
     * The password to use to authenticate with the registry where the built image will be pushed
     */
    @ConfigItem
    public Optional<String> password;

    /**
     * Whether or not insecure registries are allowed
     */
    @ConfigItem(defaultValue = "false")
    public boolean insecure;

    /**
     * Whether or not a image build will be performed.
     */
    @ConfigItem(defaultValue = "false")
    public boolean build;

    /**
     * Whether or not an image push will be performed.
     */
    @ConfigItem(defaultValue = "false")
    public boolean push;

    /**
     * Since user.name which is default value can be uppercase and uppercase values are not allowed
     * in the repository part of image references, we need to make the username lowercase.
     *
     * We purposely don't change the value of an explicitly set group.
     */
    public Optional<String> getEffectiveGroup() {
        if (group.isPresent()) {
            String originalGroup = group.get();
            if (originalGroup.equals(System.getProperty("user.name"))) {
                return Optional.of(originalGroup.toLowerCase());
            }
        }
        return group;
    }
}
