/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ContainerImageCapabilitiesUtil {
    public static final Map<String, String> CAPABILITY_TO_EXTENSION_NAME = new HashMap<String, String>();

    private ContainerImageCapabilitiesUtil() {
    }

    public static Optional<String> getActiveContainerImageCapability(Capabilities capabilities) {
        Set<String> activeContainerImageCapabilities = ContainerImageCapabilitiesUtil.getContainerImageCapabilities(capabilities);
        if (activeContainerImageCapabilities.size() > 1) {
            throw new IllegalStateException(String.join((CharSequence)" and ", activeContainerImageCapabilities) + " were detected, at most one container-image extension can be present. ");
        }
        return activeContainerImageCapabilities.isEmpty() ? Optional.empty() : Optional.of(activeContainerImageCapabilities.iterator().next());
    }

    private static Set<String> getContainerImageCapabilities(Capabilities capabilities) {
        HashSet<String> activeContainerImageCapabilities = new HashSet<String>();
        for (String capability : capabilities.getCapabilities()) {
            if (!capability.toLowerCase().contains("container.image")) continue;
            if (!CAPABILITY_TO_EXTENSION_NAME.containsKey(capability)) {
                throw new IllegalArgumentException("Unknown container image capability: " + capability);
            }
            activeContainerImageCapabilities.add(CAPABILITY_TO_EXTENSION_NAME.get(capability));
        }
        return activeContainerImageCapabilities;
    }

    static {
        CAPABILITY_TO_EXTENSION_NAME.put(Capability.CONTAINER_IMAGE_JIB.getName(), "quarkus-container-image-jib");
        CAPABILITY_TO_EXTENSION_NAME.put(Capability.CONTAINER_IMAGE_DOCKER.getName(), "quarkus-container-image-docker");
        CAPABILITY_TO_EXTENSION_NAME.put(Capability.CONTAINER_IMAGE_S2I.getName(), "quarkus-container-image-s2i");
    }
}

