/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigRoot
public class ContainerImageConfig {
    @ConfigItem(defaultValue="${user.name}")
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> group;
    @ConfigItem(defaultValue="${quarkus.application.name:unset}")
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> name;
    @ConfigItem(defaultValue="${quarkus.application.version:latest}")
    public Optional<String> tag;
    @ConfigItem
    public Optional<List<String>> additionalTags;
    @ConfigItem
    public Map<String, String> labels;
    @ConfigItem
    public Optional<String> registry;
    @ConfigItem
    public Optional<String> image;
    @ConfigItem
    public Optional<String> username;
    @ConfigItem
    public Optional<String> password;
    @ConfigItem
    public boolean insecure;
    @ConfigItem
    public boolean build;
    @ConfigItem
    public boolean push;
    @ConfigItem
    public Optional<String> builder;

    public Optional<String> getEffectiveGroup() {
        if (this.group.isPresent()) {
            String originalGroup = this.group.get();
            if (originalGroup.equals(System.getProperty("user.name"))) {
                if (originalGroup.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(originalGroup.toLowerCase().replace(' ', '-'));
            }
            if (originalGroup.isEmpty()) {
                return Optional.empty();
            }
        }
        return this.group;
    }
}

