/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageCapabilitiesUtil;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.EnablementUtil;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageCustomNameBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.spi.FallbackContainerImageRegistryBuildItem;
import io.quarkus.container.spi.ImageReference;
import io.quarkus.container.spi.SingleSegmentContainerImageRequestBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.steps.NativeSourcesBuild;
import io.quarkus.runtime.util.StringUtil;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class ContainerImageProcessor {
    private static final Logger log = Logger.getLogger(ContainerImageProcessor.class);

    @BuildStep(onlyIf={NativeSourcesBuild.class})
    void failForNativeSources(ContainerImageConfig containerImageConfig, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        if (EnablementUtil.buildOrPushContainerImageNeeded(containerImageConfig, buildRequest, pushRequest)) {
            throw new IllegalArgumentException("The Container Image extensions are incompatible with the 'native-sources' package type.");
        }
    }

    @BuildStep
    public void ignoreCredentialsChange(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> producer) {
        producer.produce((BuildItem)new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.container-image.username"));
        producer.produce((BuildItem)new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.container-image.password"));
    }

    @BuildStep
    public void publishImageInfo(ApplicationInfoBuildItem app, ContainerImageConfig containerImageConfig, Optional<SingleSegmentContainerImageRequestBuildItem> singleSegmentImageRequest, Optional<FallbackContainerImageRegistryBuildItem> containerImageRegistry, Optional<ContainerImageCustomNameBuildItem> containerImageCustomName, Capabilities capabilities, BuildProducer<ContainerImageInfoBuildItem> containerImage) {
        String repository;
        this.ensureSingleContainerImageExtension(capabilities);
        if (containerImageConfig.additionalTags.isPresent()) {
            for (String additionalTag : containerImageConfig.additionalTags.get()) {
                if (ImageReference.isValidTag((String)additionalTag)) continue;
                throw new IllegalArgumentException("The supplied additional container-image tag '" + additionalTag + "' is invalid");
            }
        }
        Optional<String> effectiveGroup = ContainerImageProcessor.getEffectiveGroup(containerImageConfig.group, singleSegmentImageRequest.isPresent());
        if (containerImageConfig.image.isPresent()) {
            ImageReference imageReference = ImageReference.parse((String)containerImageConfig.image.get());
            String repository2 = imageReference.getRepository();
            if (singleSegmentImageRequest.isPresent() && imageReference.getRepository().contains("/") && imageReference.getRegistry().filter(StringUtil::isNullOrEmpty).isPresent()) {
                log.warn((Object)("A single segment image is preferred, but a local multi segment has been provided: " + containerImageConfig.image.get()));
            }
            containerImage.produce((BuildItem)new ContainerImageInfoBuildItem(imageReference.getRegistry(), containerImageConfig.username, containerImageConfig.password, repository2, imageReference.getTag(), containerImageConfig.additionalTags.orElse(Collections.emptyList())));
            return;
        }
        String registry = containerImageConfig.registry.orElseGet(() -> containerImageRegistry.map(FallbackContainerImageRegistryBuildItem::getRegistry).orElse(null));
        if (registry != null && !ImageReference.isValidRegistry((String)registry)) {
            throw new IllegalArgumentException("The supplied container-image registry '" + registry + "' is invalid");
        }
        String effectiveName = containerImageCustomName.map(ContainerImageCustomNameBuildItem::getName).orElse(containerImageConfig.name);
        String group = effectiveGroup.orElse("");
        String string = repository = group.isBlank() ? effectiveName : group + "/" + effectiveName;
        if (!ImageReference.isValidRepository((String)repository)) {
            throw new IllegalArgumentException("The supplied combination of container-image group '" + group + "' and name '" + effectiveName + "' is invalid");
        }
        String effectiveTag = containerImageConfig.tag.orElse(app.getVersion());
        if (effectiveTag.equals("<<unset>>")) {
            effectiveTag = "latest";
        }
        if (!ImageReference.isValidTag((String)effectiveTag)) {
            throw new IllegalArgumentException("The supplied container-image tag '" + effectiveTag + "' is invalid");
        }
        containerImage.produce((BuildItem)new ContainerImageInfoBuildItem(Optional.ofNullable(registry), containerImageConfig.username, containerImageConfig.password, effectiveGroup, effectiveName, effectiveTag, containerImageConfig.additionalTags.orElse(Collections.emptyList())));
    }

    private void ensureSingleContainerImageExtension(Capabilities capabilities) {
        ContainerImageCapabilitiesUtil.getActiveContainerImageCapability(capabilities);
    }

    static Optional<String> getEffectiveGroup(Optional<String> group, boolean isSingleSegmentRequested) {
        return group.or(() -> isSingleSegmentRequested || ContainerImageProcessor.isGroupSpecified() ? Optional.empty() : Optional.ofNullable(System.getProperty("user.name")).map(s -> s.replace(' ', '-'))).map(String::toLowerCase).filter(Predicate.not(StringUtil::isNullOrEmpty));
    }

    static Optional<String> getEffectiveGroup() {
        return ContainerImageProcessor.getEffectiveGroup(Optional.empty(), false);
    }

    static boolean isGroupSpecified() {
        return StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false).anyMatch(n -> n.equals("quarkus.container-image.group") || n.equals("QUARKUS_CONTAINER_IMAGE_GROUP"));
    }
}

