/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment.util;

import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class NativeBinaryUtil {
    private NativeBinaryUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean nativeIsLinuxBinary(NativeImageBuildItem nativeImageBuildItem) {
        File file = nativeImageBuildItem.getPath().toFile();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] firstBytes = new byte[4];
            int readBytes = fileInputStream.read(firstBytes);
            if (readBytes != 4) {
                boolean bl = false;
                return bl;
            }
            boolean bl = firstBytes[0] == 127 && firstBytes[1] == 69 && firstBytes[2] == 76 && firstBytes[3] == 70;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to determine type of native binary " + String.valueOf(nativeImageBuildItem.getPath()), e);
        }
    }
}

