/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.docker.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.image.docker.deployment.DockerBuild;
import io.quarkus.container.image.docker.deployment.DockerConfig;
import io.quarkus.container.image.docker.deployment.DockerWorking;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSResultBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.util.ExecUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class DockerProcessor {
    private static final Logger log = Logger.getLogger(DockerProcessor.class);
    private static final String DOCKER = "docker";
    private static final String DOCKERFILE_JVM = "Dockerfile.jvm";
    private static final String DOCKERFILE_LEGACY_JAR = "Dockerfile.legacy-jar";
    private static final String DOCKERFILE_NATIVE = "Dockerfile.native";
    private static final String DOCKER_DIRECTORY_NAME = "docker";
    static final String DOCKER_CONTAINER_IMAGE_NAME = "docker";
    private final DockerWorking dockerWorking = new DockerWorking();

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem("docker");
    }

    @BuildStep(onlyIf={DockerBuild.class})
    public CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.CONTAINER_IMAGE_DOCKER);
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, DockerBuild.class}, onlyIfNot={NativeBuild.class})
    public void dockerBuildFromJar(DockerConfig dockerConfig, ContainerImageConfig containerImageConfig, OutputTargetBuildItem out, ContainerImageInfoBuildItem containerImageInfo, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, Optional<AppCDSResultBuildItem> appCDSResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, PackageConfig packageConfig, JarBuildItem jar) {
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        if (!this.dockerWorking.getAsBoolean()) {
            throw new RuntimeException("Unable to build docker image. Please check your docker installation");
        }
        log.info((Object)"Building docker image for jar.");
        ImageIdReader reader = new ImageIdReader();
        String builtContainerImage = this.createContainerImage(containerImageConfig, dockerConfig, containerImageInfo, out, reader, false, pushRequest.isPresent(), packageConfig);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.singletonMap("container-image", builtContainerImage)));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, NativeBuild.class, DockerBuild.class})
    public void dockerBuildFromNativeImage(DockerConfig dockerConfig, ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, OutputTargetBuildItem out, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, PackageConfig packageConfig, NativeImageBuildItem nativeImage) {
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        if (!this.dockerWorking.getAsBoolean()) {
            throw new RuntimeException("Unable to build docker image. Please check your docker installation");
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        log.info((Object)"Starting docker image build");
        ImageIdReader reader = new ImageIdReader();
        String builtContainerImage = this.createContainerImage(containerImageConfig, dockerConfig, containerImage, out, reader, true, pushRequest.isPresent(), packageConfig);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.singletonMap("container-image", builtContainerImage)));
    }

    private String createContainerImage(ContainerImageConfig containerImageConfig, DockerConfig dockerConfig, ContainerImageInfoBuildItem containerImageInfo, OutputTargetBuildItem out, ImageIdReader reader, boolean forNative, boolean pushRequested, PackageConfig packageConfig) {
        DockerfilePaths dockerfilePaths = this.getDockerfilePaths(dockerConfig, forNative, packageConfig, out);
        CharSequence[] dockerArgs = this.getDockerArgs(containerImageInfo.getImage(), dockerfilePaths, dockerConfig);
        log.infof("Executing the following command to build docker image: '%s %s'", (Object)dockerConfig.executableName, (Object)String.join((CharSequence)" ", dockerArgs));
        boolean buildSuccessful = ExecUtil.exec((File)out.getOutputDirectory().toFile(), (Function)reader, (String)dockerConfig.executableName, (String[])dockerArgs);
        if (!buildSuccessful) {
            throw this.dockerException((String[])dockerArgs);
        }
        log.infof("Built container image %s (%s)\n", (Object)containerImageInfo.getImage(), (Object)reader.getImageId());
        if (!containerImageInfo.getAdditionalImageTags().isEmpty()) {
            this.createAdditionalTags(containerImageInfo.getImage(), containerImageInfo.getAdditionalImageTags(), dockerConfig);
        }
        if (pushRequested || containerImageConfig.push) {
            boolean loginSuccessful;
            String registry = "docker.io";
            if (!containerImageInfo.getRegistry().isPresent()) {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
            } else {
                registry = (String)containerImageInfo.getRegistry().get();
            }
            if (containerImageConfig.username.isPresent() && containerImageConfig.password.isPresent() && !(loginSuccessful = ExecUtil.exec((String)dockerConfig.executableName, (String[])new String[]{"login", registry, "-u", (String)containerImageConfig.username.get(), "-p" + (String)containerImageConfig.password.get()}))) {
                throw this.dockerException(new String[]{"-u", (String)containerImageConfig.username.get(), "-p", "********"});
            }
            ArrayList<String> imagesToPush = new ArrayList<String>(containerImageInfo.getAdditionalImageTags());
            imagesToPush.add(containerImageInfo.getImage());
            for (String imageToPush : imagesToPush) {
                this.pushImage(imageToPush, dockerConfig);
            }
        }
        return containerImageInfo.getImage();
    }

    private String[] getDockerArgs(String image, DockerfilePaths dockerfilePaths, DockerConfig dockerConfig) {
        List<String> cacheFrom;
        ArrayList<String> dockerArgs = new ArrayList<String>(6 + dockerConfig.buildArgs.size());
        dockerArgs.addAll(Arrays.asList("build", "-f", dockerfilePaths.getDockerfilePath().toAbsolutePath().toString()));
        for (Map.Entry<String, String> entry : dockerConfig.buildArgs.entrySet()) {
            dockerArgs.addAll(Arrays.asList("--build-arg", entry.getKey() + "=" + entry.getValue()));
        }
        if (dockerConfig.cacheFrom.isPresent() && !(cacheFrom = dockerConfig.cacheFrom.get()).isEmpty()) {
            dockerArgs.add("--cache-from");
            dockerArgs.add(String.join((CharSequence)",", cacheFrom));
        }
        dockerArgs.addAll(Arrays.asList("-t", image));
        dockerArgs.add(dockerfilePaths.getDockerExecutionPath().toAbsolutePath().toString());
        return dockerArgs.toArray(new String[0]);
    }

    private void createAdditionalTags(String image, List<String> additionalImageTags, DockerConfig dockerConfig) {
        for (String additionalTag : additionalImageTags) {
            String[] tagArgs = new String[]{"tag", image, additionalTag};
            boolean tagSuccessful = ExecUtil.exec((String)dockerConfig.executableName, (String[])tagArgs);
            if (tagSuccessful) continue;
            throw this.dockerException(tagArgs);
        }
    }

    private void pushImage(String image, DockerConfig dockerConfig) {
        String[] pushArgs = new String[]{"push", image};
        boolean pushSuccessful = ExecUtil.exec((String)dockerConfig.executableName, (String[])pushArgs);
        if (!pushSuccessful) {
            throw this.dockerException(pushArgs);
        }
        log.info((Object)("Successfully pushed docker image " + image));
    }

    private RuntimeException dockerException(String[] dockerArgs) {
        return new RuntimeException("Execution of 'docker " + String.join((CharSequence)" ", dockerArgs) + "' failed. See docker output for more details");
    }

    private DockerfilePaths getDockerfilePaths(DockerConfig dockerConfig, boolean forNative, PackageConfig packageConfig, OutputTargetBuildItem outputTargetBuildItem) {
        Path outputDirectory = outputTargetBuildItem.getOutputDirectory();
        if (forNative) {
            if (dockerConfig.dockerfileNativePath.isPresent()) {
                return ProvidedDockerfile.get(Paths.get(dockerConfig.dockerfileNativePath.get(), new String[0]), outputDirectory);
            }
            return DockerfileDetectionResult.detect(DOCKERFILE_NATIVE, outputDirectory);
        }
        if (dockerConfig.dockerfileJvmPath.isPresent()) {
            return ProvidedDockerfile.get(Paths.get(dockerConfig.dockerfileJvmPath.get(), new String[0]), outputDirectory);
        }
        if (packageConfig.type.equals("legacy-jar")) {
            return DockerfileDetectionResult.detect(DOCKERFILE_LEGACY_JAR, outputDirectory);
        }
        return DockerfileDetectionResult.detect(DOCKERFILE_JVM, outputDirectory);
    }

    private static class ProvidedDockerfile
    implements DockerfilePaths {
        private final Path dockerfilePath;
        private final Path dockerExecutionPath;

        private ProvidedDockerfile(Path dockerfilePath, Path dockerExecutionPath) {
            this.dockerfilePath = dockerfilePath;
            this.dockerExecutionPath = dockerExecutionPath;
        }

        public static ProvidedDockerfile get(Path dockerfilePath, Path outputDirectory) {
            Path effectiveDockerfilePath;
            AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
            if (mainSourcesRoot == null) {
                throw new IllegalStateException("Unable to determine project root");
            }
            Path path = effectiveDockerfilePath = dockerfilePath.isAbsolute() ? dockerfilePath : ((Path)mainSourcesRoot.getValue()).resolve(dockerfilePath);
            if (!effectiveDockerfilePath.toFile().exists()) {
                throw new IllegalArgumentException("Specified Dockerfile path " + effectiveDockerfilePath.toAbsolutePath().toString() + " does not exist");
            }
            return new ProvidedDockerfile(effectiveDockerfilePath, (Path)mainSourcesRoot.getValue());
        }

        @Override
        public Path getDockerfilePath() {
            return this.dockerfilePath;
        }

        @Override
        public Path getDockerExecutionPath() {
            return this.dockerExecutionPath;
        }
    }

    private static class DockerfileDetectionResult
    implements DockerfilePaths {
        private final Path dockerfilePath;
        private final Path dockerExecutionPath;

        private DockerfileDetectionResult(Path dockerfilePath, Path dockerExecutionPath) {
            this.dockerfilePath = dockerfilePath;
            this.dockerExecutionPath = dockerExecutionPath;
        }

        @Override
        public Path getDockerfilePath() {
            return this.dockerfilePath;
        }

        @Override
        public Path getDockerExecutionPath() {
            return this.dockerExecutionPath;
        }

        static DockerfileDetectionResult detect(String resource, Path outputDirectory) {
            Map.Entry<Path, Path> dockerfileToExecutionRoot = DockerfileDetectionResult.findDockerfileRoot(outputDirectory);
            if (dockerfileToExecutionRoot == null) {
                throw new IllegalStateException("Unable to find root of Dockerfile files. Consider adding 'src/main/docker/' to your project root");
            }
            Path dockerFilePath = dockerfileToExecutionRoot.getKey().resolve(resource);
            if (!Files.exists(dockerFilePath, new LinkOption[0])) {
                throw new IllegalStateException("Unable to find Dockerfile " + resource + " in " + dockerfileToExecutionRoot.getKey().toAbsolutePath());
            }
            return new DockerfileDetectionResult(dockerFilePath, dockerfileToExecutionRoot.getValue());
        }

        private static Map.Entry<Path, Path> findDockerfileRoot(Path outputDirectory) {
            AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
            if (mainSourcesRoot == null) {
                return null;
            }
            Path dockerfilesRoot = ((Path)mainSourcesRoot.getKey()).resolve("docker");
            if (!dockerfilesRoot.toFile().exists()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<Path, Path>(dockerfilesRoot, (Path)mainSourcesRoot.getValue());
        }
    }

    private static interface DockerfilePaths {
        public Path getDockerfilePath();

        public Path getDockerExecutionPath();
    }

    private static class ImageIdReader
    implements Function<InputStream, Runnable> {
        private final AtomicReference<String> id = new AtomicReference();

        private ImageIdReader() {
        }

        public String getImageId() {
            return this.id.get();
        }

        @Override
        public Runnable apply(final InputStream t) {
            return new Runnable(){

                @Override
                public void run() {
                    try (InputStreamReader isr = new InputStreamReader(t);
                         BufferedReader reader = new BufferedReader(isr);){
                        String line = reader.readLine();
                        while (line != null) {
                            String[] parts;
                            if (line.startsWith("Successfully built") && (parts = line.split(" ")).length == 3) {
                                id.set(parts[2]);
                            }
                            log.info((Object)line);
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }
}

