/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.docker.deployment;

import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.docker.common.deployment.CommonConfig;
import io.quarkus.container.image.docker.common.deployment.CommonProcessor;
import io.quarkus.container.image.docker.deployment.DockerBuild;
import io.quarkus.container.image.docker.deployment.DockerConfig;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ContainerRuntimeStatusBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSResultBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UpxCompressedBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

public class DockerProcessor
extends CommonProcessor<DockerConfig> {
    private static final Logger LOG = Logger.getLogger(DockerProcessor.class);
    private static final String DOCKER = "docker";
    static final String DOCKER_CONTAINER_IMAGE_NAME = "docker";

    protected String getProcessorImplementation() {
        return "docker";
    }

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem("docker");
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, DockerBuild.class}, onlyIfNot={NativeBuild.class})
    public void dockerBuildFromJar(DockerConfig dockerConfig, DockerStatusBuildItem dockerStatusBuildItem, ContainerImageConfig containerImageConfig, OutputTargetBuildItem out, ContainerImageInfoBuildItem containerImageInfo, CompiledJavaVersionBuildItem compiledJavaVersion, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, Optional<AppCDSResultBuildItem> appCDSResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, PackageConfig packageConfig, JarBuildItem jar) {
        this.buildFromJar(dockerConfig, (ContainerRuntimeStatusBuildItem)dockerStatusBuildItem, containerImageConfig, out, containerImageInfo, buildRequest, pushRequest, artifactResultProducer, containerImageBuilder, packageConfig, new ContainerRuntimeUtil.ContainerRuntime[]{ContainerRuntimeUtil.ContainerRuntime.DOCKER, ContainerRuntimeUtil.ContainerRuntime.PODMAN});
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, NativeBuild.class, DockerBuild.class})
    public void dockerBuildFromNativeImage(DockerConfig dockerConfig, DockerStatusBuildItem dockerStatusBuildItem, ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, OutputTargetBuildItem out, Optional<UpxCompressedBuildItem> upxCompressed, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, PackageConfig packageConfig, NativeImageBuildItem nativeImage) {
        this.buildFromNativeImage(dockerConfig, (ContainerRuntimeStatusBuildItem)dockerStatusBuildItem, containerImageConfig, containerImage, buildRequest, pushRequest, out, artifactResultProducer, containerImageBuilder, packageConfig, nativeImage, new ContainerRuntimeUtil.ContainerRuntime[]{ContainerRuntimeUtil.ContainerRuntime.DOCKER, ContainerRuntimeUtil.ContainerRuntime.PODMAN});
    }

    protected String createContainerImage(ContainerImageConfig containerImageConfig, DockerConfig dockerConfig, ContainerImageInfoBuildItem containerImageInfo, OutputTargetBuildItem out, CommonProcessor.DockerfilePaths dockerfilePaths, boolean buildContainerImage, boolean pushContainerImage, PackageConfig packageConfig, String executableName) {
        boolean useBuildx = dockerConfig.buildx().useBuildx();
        if (useBuildx && pushContainerImage) {
            this.loginToRegistryIfNeeded(containerImageConfig, containerImageInfo, executableName);
        }
        if (buildContainerImage) {
            String[] dockerBuildArgs = this.getDockerBuildArgs(containerImageInfo.getImage(), dockerfilePaths, containerImageConfig, dockerConfig, containerImageInfo, pushContainerImage, executableName);
            this.buildImage(containerImageInfo, out, executableName, dockerBuildArgs, false);
            dockerConfig.buildx().platform().filter(platform -> !platform.isEmpty()).ifPresentOrElse(platform -> LOG.infof("Built container image %s (%s platform(s))\n", (Object)containerImageInfo.getImage(), (Object)String.join((CharSequence)",", platform)), () -> LOG.infof("Built container image %s\n", (Object)containerImageInfo.getImage()));
            if (!useBuildx && !containerImageInfo.getAdditionalImageTags().isEmpty()) {
                this.createAdditionalTags(containerImageInfo.getImage(), containerImageInfo.getAdditionalImageTags(), executableName);
            }
        }
        if (!useBuildx && pushContainerImage) {
            this.loginToRegistryIfNeeded(containerImageConfig, containerImageInfo, executableName);
            this.pushImages(containerImageInfo, executableName, dockerConfig);
        }
        return containerImageInfo.getImage();
    }

    protected String getExecutableName(DockerConfig config, ContainerRuntimeUtil.ContainerRuntime ... containerRuntimes) {
        String executableName = super.getExecutableName((CommonConfig)config, containerRuntimes);
        if (!"docker".equals(executableName)) {
            LOG.warnf("Using executable %s within the quarkus-container-image-%s extension. Maybe you should use the quarkus-container-image-%s extension instead?", (Object)executableName, (Object)"docker", (Object)executableName);
        }
        return executableName;
    }

    private String[] getDockerBuildArgs(String image, CommonProcessor.DockerfilePaths dockerfilePaths, ContainerImageConfig containerImageConfig, DockerConfig dockerConfig, ContainerImageInfoBuildItem containerImageInfo, boolean pushImages, String executableName) {
        List dockerBuildArgs = this.getContainerCommonBuildArgs(image, dockerfilePaths, containerImageConfig, dockerConfig, true);
        DockerConfig.DockerBuildxConfig buildx = dockerConfig.buildx();
        boolean useBuildx = buildx.useBuildx();
        if (useBuildx) {
            if (!"docker".equals(executableName)) {
                throw new IllegalArgumentException("The 'buildx' properties are specific to 'executable-name=docker' and can not be used with the '%s' executable name. Either remove the `buildx` properties or the `executable-name` property.".formatted(executableName));
            }
            dockerBuildArgs.add(0, "buildx");
        }
        buildx.platform().filter(platform -> !platform.isEmpty()).ifPresent(platform -> {
            dockerBuildArgs.addAll(List.of("--platform", String.join((CharSequence)",", platform)));
            if (platform.size() == 1) {
                dockerBuildArgs.add("--load");
            }
        });
        buildx.progress().ifPresent(progress -> dockerBuildArgs.addAll(List.of("--progress", progress)));
        buildx.output().ifPresent(output -> dockerBuildArgs.addAll(List.of("--output", output)));
        if (useBuildx) {
            containerImageInfo.getAdditionalImageTags().forEach(additionalImageTag -> dockerBuildArgs.addAll(List.of("-t", additionalImageTag)));
            if (pushImages) {
                dockerBuildArgs.add("--push");
            }
        }
        dockerBuildArgs.add(dockerfilePaths.dockerExecutionPath().toAbsolutePath().toString());
        return (String[])dockerBuildArgs.toArray(String[]::new);
    }
}

