/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.jib.deployment;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.image.jib.deployment.JibBuild;
import io.quarkus.container.image.jib.deployment.JibConfig;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.spi.ContainerImageResultBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class JibProcessor {
    private static final Logger log = Logger.getLogger(JibProcessor.class);
    private static final String JIB = "jib";
    private static final IsClassPredicate IS_CLASS_PREDICATE = new IsClassPredicate();
    private static final String BINARY_NAME_IN_CONTAINER = "application";

    @BuildStep(onlyIf={IsNormal.class, JibBuild.class}, onlyIfNot={NativeBuild.class})
    public void buildFromJar(ContainerImageConfig containerImageConfig, JibConfig jibConfig, JarBuildItem sourceJar, MainClassBuildItem mainClass, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageResultBuildItem> containerImageResultProducer) {
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        JibContainerBuilder jibContainerBuilder = this.createContainerBuilderFromJar(containerImageConfig, jibConfig, sourceJar, outputTarget, mainClass, containerImageLabels);
        JibContainer container = this.containerize(applicationInfo, containerImageConfig, jibConfig, jibContainerBuilder, pushRequest.isPresent());
        ImageReference targetImage = container.getTargetImage();
        containerImageResultProducer.produce((BuildItem)new ContainerImageResultBuildItem(JIB, container.getImageId().getHash(), targetImage.getRepository(), targetImage.getTag()));
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.emptyMap()));
    }

    @BuildStep(onlyIf={IsNormal.class, JibBuild.class, NativeBuild.class})
    public void buildFromNative(ContainerImageConfig containerImageConfig, JibConfig jibConfig, NativeImageBuildItem nativeImage, ApplicationInfoBuildItem applicationInfo, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageResultBuildItem> containerImageResultProducer) {
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        JibContainerBuilder jibContainerBuilder = this.createContainerBuilderFromNative(containerImageConfig, jibConfig, nativeImage, containerImageLabels);
        JibContainer container = this.containerize(applicationInfo, containerImageConfig, jibConfig, jibContainerBuilder, pushRequest.isPresent());
        ImageReference targetImage = container.getTargetImage();
        containerImageResultProducer.produce((BuildItem)new ContainerImageResultBuildItem(JIB, container.getImageId().getHash(), targetImage.getRepository(), targetImage.getTag()));
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.emptyMap()));
    }

    private JibContainer containerize(ApplicationInfoBuildItem applicationInfo, ContainerImageConfig containerImageConfig, JibConfig jibConfig, JibContainerBuilder jibContainerBuilder, boolean pushRequested) {
        Containerizer containerizer = this.createContainerizer(containerImageConfig, jibConfig, applicationInfo, pushRequested);
        try {
            log.info((Object)"Starting container image build");
            JibContainer container = jibContainerBuilder.containerize(containerizer);
            log.infof("%s container image %s (%s)\n", (Object)(containerImageConfig.push ? "Pushed" : "Created"), (Object)container.getTargetImage(), (Object)container.getDigest());
            return container;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create container image", e);
        }
    }

    private Containerizer createContainerizer(ContainerImageConfig containerImageConfig, JibConfig jibConfig, ApplicationInfoBuildItem applicationInfo, boolean pushRequested) {
        Containerizer containerizer;
        ImageReference imageReference = this.getImageReference(containerImageConfig, applicationInfo);
        if (pushRequested || containerImageConfig.push) {
            if (!containerImageConfig.registry.isPresent()) {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
            }
            RegistryImage registryImage = this.toRegistryImage(imageReference, containerImageConfig);
            containerizer = Containerizer.to((RegistryImage)registryImage);
        } else {
            containerizer = Containerizer.to((DockerDaemonImage)DockerDaemonImage.named((ImageReference)imageReference));
        }
        containerizer.setToolName("Quarkus");
        containerizer.addEventHandler(LogEvent.class, e -> {
            if (!e.getMessage().isEmpty()) {
                log.log(this.toJBossLoggingLevel(e.getLevel()), (Object)e.getMessage());
            }
        });
        containerizer.setAllowInsecureRegistries(containerImageConfig.insecure);
        return containerizer;
    }

    private RegistryImage toRegistryImage(ImageReference imageReference, ContainerImageConfig containerImageConfig) {
        CredentialRetrieverFactory credentialRetrieverFactory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, arg_0 -> ((Logger)log).info(arg_0));
        RegistryImage registryImage = RegistryImage.named((ImageReference)imageReference);
        registryImage.addCredentialRetriever(credentialRetrieverFactory.wellKnownCredentialHelpers());
        registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig());
        if (containerImageConfig.username.isPresent() && containerImageConfig.password.isPresent()) {
            registryImage.addCredential((String)containerImageConfig.username.get(), (String)containerImageConfig.password.get());
        }
        return registryImage;
    }

    private Logger.Level toJBossLoggingLevel(LogEvent.Level level) {
        switch (level) {
            case ERROR: {
                return Logger.Level.ERROR;
            }
            case WARN: {
                return Logger.Level.WARN;
            }
            case LIFECYCLE: {
                return Logger.Level.INFO;
            }
        }
        return Logger.Level.DEBUG;
    }

    private ImageReference getImageReference(ContainerImageConfig containerImageConfig, ApplicationInfoBuildItem applicationInfo) {
        return ImageReference.of((String)containerImageConfig.registry.orElse(null), (String)(containerImageConfig.group.map(s -> s + "/").orElse("") + containerImageConfig.name.orElse(applicationInfo.getName())), (String)containerImageConfig.tag.orElse(applicationInfo.getVersion()));
    }

    private JibContainerBuilder createContainerBuilderFromJar(ContainerImageConfig containerImageConfig, JibConfig jibConfig, JarBuildItem sourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, MainClassBuildItem mainClassBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        try {
            Path classesDir = outputTargetBuildItem.getOutputDirectory().resolve(JIB);
            ZipUtils.unzip((Path)sourceJarBuildItem.getPath(), (Path)classesDir);
            JavaContainerBuilder javaContainerBuilder = JavaContainerBuilder.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseJvmImage), containerImageConfig)).addResources(classesDir, IS_CLASS_PREDICATE.negate()).addClasses(classesDir, (Predicate)IS_CLASS_PREDICATE).addJvmFlags(jibConfig.jvmArguments).setMainClass(mainClassBuildItem.getClassName());
            if (sourceJarBuildItem.getLibraryDir() != null) {
                javaContainerBuilder.addDependencies(Files.list(sourceJarBuildItem.getLibraryDir()).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".jar")).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toList()));
            }
            return javaContainerBuilder.toContainerBuilder().setEnvironment(jibConfig.environmentVariables).setLabels(this.allLabels(jibConfig, containerImageLabels)).setCreationTime(Instant.now());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private JibContainerBuilder createContainerBuilderFromNative(ContainerImageConfig containerImageConfig, JibConfig jibConfig, NativeImageBuildItem nativeImageBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        ArrayList<String> entrypoint = new ArrayList<String>(jibConfig.nativeArguments.size() + 1);
        entrypoint.add("./application");
        entrypoint.addAll(jibConfig.nativeArguments);
        try {
            AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)"/work");
            return Jib.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseNativeImage), containerImageConfig)).addLayer(LayerConfiguration.builder().addEntry(nativeImageBuildItem.getPath(), workDirInContainer.resolve(BINARY_NAME_IN_CONTAINER), FilePermissions.fromOctalString((String)"775")).build()).setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(jibConfig.environmentVariables).setLabels(this.allLabels(jibConfig, containerImageLabels)).setCreationTime(Instant.now());
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> allLabels(JibConfig jibConfig, List<ContainerImageLabelBuildItem> containerImageLabels) {
        if (jibConfig.labels.isEmpty() && containerImageLabels.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> allLabels = new HashMap<String, String>(jibConfig.labels);
        for (ContainerImageLabelBuildItem containerImageLabel : containerImageLabels) {
            allLabels.putIfAbsent(containerImageLabel.getName(), containerImageLabel.getValue());
        }
        return allLabels;
    }

    private static class IsClassPredicate
    implements Predicate<Path> {
        private IsClassPredicate() {
        }

        @Override
        public boolean test(Path path) {
            return path.getFileName().toString().endsWith(".class");
        }
    }
}

