/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.jib.deployment;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.image.jib.deployment.ContainerBuilderHelper;
import io.quarkus.container.image.jib.deployment.JibBuild;
import io.quarkus.container.image.jib.deployment.JibConfig;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class JibProcessor {
    private static final Logger log = Logger.getLogger(JibProcessor.class);
    public static final String JIB = "jib";
    private static final IsClassPredicate IS_CLASS_PREDICATE = new IsClassPredicate();
    private static final String BINARY_NAME_IN_CONTAINER = "application";

    @BuildStep(onlyIf={JibBuild.class})
    public CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.CONTAINER_IMAGE_JIB);
    }

    @BuildStep(onlyIf={IsNormal.class, JibBuild.class}, onlyIfNot={NativeBuild.class})
    public void buildFromJar(ContainerImageConfig containerImageConfig, JibConfig jibConfig, PackageConfig packageConfig, ContainerImageInfoBuildItem containerImage, JarBuildItem sourceJar, MainClassBuildItem mainClass, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        JibContainerBuilder jibContainerBuilder;
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        String packageType = packageConfig.type;
        if (packageConfig.isLegacyJar() || packageType.equalsIgnoreCase("uber-jar")) {
            jibContainerBuilder = this.createContainerBuilderFromLegacyJar(jibConfig, sourceJar, outputTarget, mainClass, containerImageLabels);
        } else if (packageConfig.isFastJar()) {
            jibContainerBuilder = this.createContainerBuilderFromFastJar(jibConfig, sourceJar, containerImageLabels);
        } else {
            throw new IllegalArgumentException("Package type '" + packageType + "' is not supported by the container-image-jib extension");
        }
        this.handleExtraFiles(outputTarget, jibContainerBuilder);
        this.containerize(applicationInfo, containerImageConfig, containerImage, jibContainerBuilder, pushRequest.isPresent());
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.emptyMap()));
    }

    @BuildStep(onlyIf={IsNormal.class, JibBuild.class, NativeBuild.class})
    public void buildFromNative(ContainerImageConfig containerImageConfig, JibConfig jibConfig, ContainerImageInfoBuildItem containerImage, NativeImageBuildItem nativeImage, ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        if (!(containerImageConfig.build || containerImageConfig.push || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        JibContainerBuilder jibContainerBuilder = this.createContainerBuilderFromNative(containerImageConfig, jibConfig, nativeImage, containerImageLabels);
        this.handleExtraFiles(outputTarget, jibContainerBuilder);
        this.containerize(applicationInfo, containerImageConfig, containerImage, jibContainerBuilder, pushRequest.isPresent());
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.emptyMap()));
    }

    private JibContainer containerize(ApplicationInfoBuildItem applicationInfo, ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, JibContainerBuilder jibContainerBuilder, boolean pushRequested) {
        Containerizer containerizer = this.createContainerizer(containerImageConfig, containerImage, applicationInfo, pushRequested);
        for (String additionalTag : containerImage.getAdditionalTags()) {
            containerizer.withAdditionalTag(additionalTag);
        }
        try {
            log.info((Object)"Starting container image build");
            JibContainer container = jibContainerBuilder.containerize(containerizer);
            log.infof("%s container image %s (%s)\n", (Object)(containerImageConfig.push ? "Pushed" : "Created"), (Object)container.getTargetImage(), (Object)container.getDigest());
            return container;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create container image", e);
        }
    }

    private Containerizer createContainerizer(ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, ApplicationInfoBuildItem applicationInfo, boolean pushRequested) {
        Containerizer containerizer;
        ImageReference imageReference = this.getImageReference(containerImageConfig, containerImage, applicationInfo);
        for (String additionalTag : containerImage.getAdditionalTags()) {
            if (ImageReference.isValidTag((String)additionalTag)) continue;
            throw new IllegalArgumentException("The supplied container-image additional tag '" + additionalTag + "' is invalid");
        }
        if (pushRequested || containerImageConfig.push) {
            if (!containerImageConfig.registry.isPresent()) {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
            }
            RegistryImage registryImage = this.toRegistryImage(imageReference, containerImageConfig.username, containerImageConfig.password);
            containerizer = Containerizer.to((RegistryImage)registryImage);
        } else {
            containerizer = Containerizer.to((DockerDaemonImage)DockerDaemonImage.named((ImageReference)imageReference));
        }
        containerizer.setToolName("Quarkus");
        containerizer.addEventHandler(LogEvent.class, e -> {
            if (!e.getMessage().isEmpty()) {
                log.log(this.toJBossLoggingLevel(e.getLevel()), (Object)e.getMessage());
            }
        });
        containerizer.setAllowInsecureRegistries(containerImageConfig.insecure);
        return containerizer;
    }

    private RegistryImage toRegistryImage(ImageReference imageReference, Optional<String> username, Optional<String> password) {
        CredentialRetrieverFactory credentialRetrieverFactory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, arg_0 -> ((Logger)log).info(arg_0));
        RegistryImage registryImage = RegistryImage.named((ImageReference)imageReference);
        registryImage.addCredentialRetriever(credentialRetrieverFactory.wellKnownCredentialHelpers());
        registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig());
        if (username.isPresent() && password.isPresent()) {
            registryImage.addCredential(username.get(), password.get());
        }
        return registryImage;
    }

    private Logger.Level toJBossLoggingLevel(LogEvent.Level level) {
        switch (level) {
            case ERROR: {
                return Logger.Level.ERROR;
            }
            case WARN: {
                return Logger.Level.WARN;
            }
            case LIFECYCLE: {
                return Logger.Level.INFO;
            }
        }
        return Logger.Level.DEBUG;
    }

    private ImageReference getImageReference(ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, ApplicationInfoBuildItem applicationInfo) {
        String registry = containerImageConfig.registry.orElse(null);
        if (registry != null && !ImageReference.isValidRegistry((String)registry)) {
            throw new IllegalArgumentException("The supplied container-image registry '" + registry + "' is invalid");
        }
        String repository = containerImageConfig.getEffectiveGroup().map(s -> s + "/").orElse("") + containerImageConfig.name.orElse(applicationInfo.getName());
        if (!ImageReference.isValidRepository((String)repository)) {
            throw new IllegalArgumentException("The supplied container-image repository '" + repository + "' is invalid");
        }
        String tag = containerImage.getTag();
        if (!ImageReference.isValidTag((String)tag)) {
            throw new IllegalArgumentException("The supplied container-image tag '" + tag + "' is invalid");
        }
        return ImageReference.of((String)registry, (String)repository, (String)tag);
    }

    private JibContainerBuilder createContainerBuilderFromFastJar(JibConfig jibConfig, JarBuildItem sourceJarBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        List<String> entrypoint;
        Path componentsPath = sourceJarBuildItem.getPath().getParent();
        AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)"/work");
        if (jibConfig.jvmEntrypoint.isPresent()) {
            entrypoint = jibConfig.jvmEntrypoint.get();
        } else {
            entrypoint = new ArrayList<String>(3 + jibConfig.jvmArguments.size());
            entrypoint.add("java");
            entrypoint.addAll(jibConfig.jvmArguments);
            entrypoint.add("-jar");
            entrypoint.add("quarkus-run.jar");
        }
        try {
            return Jib.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseJvmImage), jibConfig.baseRegistryUsername, jibConfig.baseRegistryPassword)).addLayer(Collections.singletonList(componentsPath.resolve("lib")), workDirInContainer).addLayer(Collections.singletonList(componentsPath.resolve("quarkus-run.jar")), workDirInContainer).addLayer(Collections.singletonList(componentsPath.resolve("app")), workDirInContainer).addLayer(Collections.singletonList(componentsPath.resolve("quarkus")), workDirInContainer).setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(jibConfig.environmentVariables).setLabels(this.allLabels(jibConfig, containerImageLabels)).setCreationTime(Instant.now());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private JibContainerBuilder createContainerBuilderFromLegacyJar(JibConfig jibConfig, JarBuildItem sourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, MainClassBuildItem mainClassBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        try {
            Path classesDir = outputTargetBuildItem.getOutputDirectory().resolve(JIB);
            ZipUtils.unzip((Path)sourceJarBuildItem.getPath(), (Path)classesDir);
            JavaContainerBuilder javaContainerBuilder = JavaContainerBuilder.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseJvmImage), jibConfig.baseRegistryUsername, jibConfig.baseRegistryPassword)).addResources(classesDir, IS_CLASS_PREDICATE.negate()).addClasses(classesDir, (Predicate)IS_CLASS_PREDICATE);
            if (!jibConfig.jvmEntrypoint.isPresent()) {
                javaContainerBuilder.addJvmFlags(jibConfig.jvmArguments).setMainClass(mainClassBuildItem.getClassName());
            }
            if (sourceJarBuildItem.getLibraryDir() != null) {
                javaContainerBuilder.addDependencies(Files.list(sourceJarBuildItem.getLibraryDir()).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".jar")).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toList()));
            }
            JibContainerBuilder jibContainerBuilder = javaContainerBuilder.toContainerBuilder().setEnvironment(jibConfig.environmentVariables).setLabels(this.allLabels(jibConfig, containerImageLabels)).setCreationTime(Instant.now());
            if (jibConfig.jvmEntrypoint.isPresent()) {
                jibContainerBuilder.setEntrypoint(jibConfig.jvmEntrypoint.get());
            }
            return jibContainerBuilder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private JibContainerBuilder createContainerBuilderFromNative(ContainerImageConfig containerImageConfig, JibConfig jibConfig, NativeImageBuildItem nativeImageBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        List<String> entrypoint;
        if (jibConfig.nativeEntrypoint.isPresent()) {
            entrypoint = jibConfig.nativeEntrypoint.get();
        } else {
            entrypoint = new ArrayList<String>(jibConfig.nativeArguments.size() + 1);
            entrypoint.add("./application");
            entrypoint.addAll(jibConfig.nativeArguments);
        }
        try {
            AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)"/work");
            return Jib.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseNativeImage), containerImageConfig.username, containerImageConfig.password)).addFileEntriesLayer(FileEntriesLayer.builder().addEntry(nativeImageBuildItem.getPath(), workDirInContainer.resolve(BINARY_NAME_IN_CONTAINER), FilePermissions.fromOctalString((String)"775")).build()).setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(jibConfig.environmentVariables).setLabels(this.allLabels(jibConfig, containerImageLabels)).setCreationTime(Instant.now());
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleExtraFiles(OutputTargetBuildItem outputTarget, JibContainerBuilder jibContainerBuilder) {
        Path outputDirectory = outputTarget.getOutputDirectory();
        PathsUtil.findMainSourcesRoot((Path)outputTarget.getOutputDirectory());
        AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
        if (mainSourcesRoot == null) {
            return;
        }
        Path jibFilesRoot = ((Path)mainSourcesRoot.getKey()).resolve(JIB);
        if (!jibFilesRoot.toFile().exists()) {
            return;
        }
        try {
            FileEntriesLayer extraFilesLayer = ContainerBuilderHelper.extraDirectoryLayerConfiguration(jibFilesRoot, AbsoluteUnixPath.get((String)"/"), Collections.emptyMap(), (localPath, ignored2) -> {
                try {
                    return Files.getLastModifiedTime(localPath, new LinkOption[0]).toInstant();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            jibContainerBuilder.addFileEntriesLayer(extraFilesLayer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to add extra files in '" + jibFilesRoot.toAbsolutePath().toString() + "' to the container", e);
        }
    }

    private Map<String, String> allLabels(JibConfig jibConfig, List<ContainerImageLabelBuildItem> containerImageLabels) {
        if (jibConfig.labels.isEmpty() && containerImageLabels.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> allLabels = new HashMap<String, String>(jibConfig.labels);
        for (ContainerImageLabelBuildItem containerImageLabel : containerImageLabels) {
            allLabels.putIfAbsent(containerImageLabel.getName(), containerImageLabel.getValue());
        }
        return allLabels;
    }

    private static class IsClassPredicate
    implements Predicate<Path> {
        private IsClassPredicate() {
        }

        @Override
        public boolean test(Path path) {
            return path.getFileName().toString().endsWith(".class");
        }
    }
}

