/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.jib.deployment;

import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;

final class ContainerBuilderHelper {
    private ContainerBuilderHelper() {
    }

    public static FileEntriesLayer extraDirectoryLayerConfiguration(Path sourceDirectory, AbsoluteUnixPath targetDirectory, Map<String, FilePermissions> extraDirectoryPermissions, BiFunction<Path, AbsoluteUnixPath, Instant> modificationTimeProvider) throws IOException {
        FileEntriesLayer.Builder builder = FileEntriesLayer.builder().setName(JavaContainerBuilder.LayerType.EXTRA_FILES.getName());
        LinkedHashMap<PathMatcher, FilePermissions> pathMatchers = new LinkedHashMap<PathMatcher, FilePermissions>();
        for (Map.Entry<String, FilePermissions> entry : extraDirectoryPermissions.entrySet()) {
            pathMatchers.put(FileSystems.getDefault().getPathMatcher("glob:" + entry.getKey()), entry.getValue());
        }
        new DirectoryWalker(sourceDirectory).filterRoot().walk(localPath -> {
            AbsoluteUnixPath pathOnContainer = targetDirectory.resolve(sourceDirectory.relativize(localPath));
            Instant modificationTime = (Instant)modificationTimeProvider.apply(localPath, pathOnContainer);
            FilePermissions permissions = (FilePermissions)extraDirectoryPermissions.get(pathOnContainer.toString());
            if (permissions == null) {
                Path containerPath = Paths.get(pathOnContainer.toString(), new String[0]);
                for (Map.Entry entry : pathMatchers.entrySet()) {
                    if (!((PathMatcher)entry.getKey()).matches(containerPath)) continue;
                    builder.addEntry(localPath, pathOnContainer, (FilePermissions)entry.getValue(), modificationTime);
                    return;
                }
                if (localPath.toFile().canExecute()) {
                    builder.addEntry(localPath, pathOnContainer, FilePermissions.fromOctalString((String)"755"), modificationTime);
                } else {
                    builder.addEntry(localPath, pathOnContainer, modificationTime);
                }
            } else {
                builder.addEntry(localPath, pathOnContainer, permissions, modificationTime);
            }
        });
        return builder.build();
    }
}

