/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.jib.deployment;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.image.jib.deployment.ContainerBuilderHelper;
import io.quarkus.container.image.jib.deployment.JibBuild;
import io.quarkus.container.image.jib.deployment.JibConfig;
import io.quarkus.container.image.jib.deployment.PlatformHelper;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSContainerImageBuildItem;
import io.quarkus.deployment.pkg.builditem.AppCDSResultBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UpxCompressedBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class JibProcessor {
    private static final Logger log = Logger.getLogger(JibProcessor.class);
    public static final String JIB = "jib";
    private static final IsClassPredicate IS_CLASS_PREDICATE = new IsClassPredicate();
    private static final String BINARY_NAME_IN_CONTAINER = "application";

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem(JIB);
    }

    @BuildStep(onlyIf={JibBuild.class})
    public void appCDS(ContainerImageConfig containerImageConfig, JibConfig jibConfig, BuildProducer<AppCDSContainerImageBuildItem> producer) {
        if (!containerImageConfig.build && !containerImageConfig.push) {
            return;
        }
        producer.produce((BuildItem)new AppCDSContainerImageBuildItem(jibConfig.baseJvmImage));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, JibBuild.class}, onlyIfNot={NativeBuild.class})
    public void buildFromJar(ContainerImageConfig containerImageConfig, JibConfig jibConfig, PackageConfig packageConfig, ContainerImageInfoBuildItem containerImage, JarBuildItem sourceJar, MainClassBuildItem mainClass, OutputTargetBuildItem outputTarget, CurateOutcomeBuildItem curateOutcome, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<AppCDSResultBuildItem> appCDSResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        JibContainerBuilder jibContainerBuilder;
        Boolean buildContainerImage = containerImageConfig.build || buildRequest.isPresent();
        Boolean pushContainerImage = containerImageConfig.push || pushRequest.isPresent();
        if (!buildContainerImage.booleanValue() && !pushContainerImage.booleanValue()) {
            return;
        }
        String packageType = packageConfig.type;
        if (packageConfig.isLegacyJar() || packageType.equalsIgnoreCase("uber-jar")) {
            jibContainerBuilder = this.createContainerBuilderFromLegacyJar(jibConfig, containerImageConfig, sourceJar, outputTarget, mainClass, containerImageLabels);
        } else if (packageConfig.isFastJar()) {
            jibContainerBuilder = this.createContainerBuilderFromFastJar(jibConfig, containerImageConfig, sourceJar, curateOutcome, containerImageLabels, appCDSResult);
        } else {
            throw new IllegalArgumentException("Package type '" + packageType + "' is not supported by the container-image-jib extension");
        }
        this.setUser(jibConfig, jibContainerBuilder);
        this.setPlatforms(jibConfig, jibContainerBuilder);
        this.handleExtraFiles(outputTarget, jibContainerBuilder);
        JibContainer container = this.containerize(containerImageConfig, jibConfig, containerImage, jibContainerBuilder, pushRequest.isPresent());
        this.writeOutputFiles(container, jibConfig, outputTarget);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Map.of("container-image", container.getTargetImage().toString(), "pull-required", pushContainerImage.toString())));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, JibBuild.class, NativeBuild.class})
    public void buildFromNative(ContainerImageConfig containerImageConfig, JibConfig jibConfig, ContainerImageInfoBuildItem containerImage, NativeImageBuildItem nativeImage, OutputTargetBuildItem outputTarget, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<UpxCompressedBuildItem> upxCompressed, BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        Boolean buildContainerImage = containerImageConfig.build || buildRequest.isPresent();
        Boolean pushContainerImage = containerImageConfig.push || pushRequest.isPresent();
        if (!buildContainerImage.booleanValue() && !pushContainerImage.booleanValue()) {
            return;
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        JibContainerBuilder jibContainerBuilder = this.createContainerBuilderFromNative(jibConfig, containerImageConfig, nativeImage, containerImageLabels);
        this.setUser(jibConfig, jibContainerBuilder);
        this.setPlatforms(jibConfig, jibContainerBuilder);
        this.handleExtraFiles(outputTarget, jibContainerBuilder);
        JibContainer container = this.containerize(containerImageConfig, jibConfig, containerImage, jibContainerBuilder, pushRequest.isPresent());
        this.writeOutputFiles(container, jibConfig, outputTarget);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Map.of("container-image", container.getTargetImage().toString(), "pull-required", pushContainerImage.toString())));
    }

    private JibContainer containerize(ContainerImageConfig containerImageConfig, JibConfig jibConfig, ContainerImageInfoBuildItem containerImage, JibContainerBuilder jibContainerBuilder, boolean pushRequested) {
        Containerizer containerizer = this.createContainerizer(containerImageConfig, jibConfig, containerImage, pushRequested);
        for (String additionalTag : containerImage.getAdditionalTags()) {
            containerizer.withAdditionalTag(additionalTag);
        }
        try {
            log.info((Object)"Starting container image build");
            JibContainer container = jibContainerBuilder.containerize(containerizer);
            log.infof("%s container image %s (%s)\n", (Object)(containerImageConfig.push ? "Pushed" : "Created"), (Object)container.getTargetImage(), (Object)container.getDigest());
            return container;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create container image", e);
        }
    }

    private Containerizer createContainerizer(ContainerImageConfig containerImageConfig, JibConfig jibConfig, ContainerImageInfoBuildItem containerImage, boolean pushRequested) {
        Containerizer containerizer;
        ImageReference imageReference = ImageReference.of((String)containerImage.getRegistry().orElse(null), (String)containerImage.getRepository(), (String)containerImage.getTag());
        if (pushRequested || containerImageConfig.push) {
            if (!containerImageConfig.registry.isPresent()) {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
            }
            RegistryImage registryImage = this.toRegistryImage(imageReference, containerImageConfig.username, containerImageConfig.password);
            containerizer = Containerizer.to((RegistryImage)registryImage);
        } else {
            DockerDaemonImage dockerDaemonImage = DockerDaemonImage.named((ImageReference)imageReference);
            Optional dockerConfigExecutableName = ConfigProvider.getConfig().getOptionalValue("quarkus.docker.executable-name", String.class);
            Optional<String> jibConfigExecutableName = jibConfig.dockerExecutableName;
            if (jibConfigExecutableName.isPresent()) {
                dockerDaemonImage.setDockerExecutable(Paths.get(jibConfigExecutableName.get(), new String[0]));
            } else if (dockerConfigExecutableName.isPresent()) {
                dockerDaemonImage.setDockerExecutable(Paths.get((String)dockerConfigExecutableName.get(), new String[0]));
            }
            containerizer = Containerizer.to((DockerDaemonImage)dockerDaemonImage);
        }
        containerizer.setToolName("Quarkus");
        containerizer.setToolVersion(Version.getVersion());
        containerizer.addEventHandler(LogEvent.class, e -> {
            if (!e.getMessage().isEmpty()) {
                log.log(this.toJBossLoggingLevel(e.getLevel()), (Object)e.getMessage());
            }
        });
        containerizer.setAllowInsecureRegistries(containerImageConfig.insecure);
        containerizer.setAlwaysCacheBaseImage(jibConfig.alwaysCacheBaseImage);
        containerizer.setOfflineMode(jibConfig.offlineMode);
        return containerizer;
    }

    private void writeOutputFiles(JibContainer jibContainer, JibConfig jibConfig, OutputTargetBuildItem outputTarget) {
        this.doWriteOutputFile(outputTarget, Paths.get(jibConfig.imageDigestFile, new String[0]), jibContainer.getDigest().toString());
        this.doWriteOutputFile(outputTarget, Paths.get(jibConfig.imageIdFile, new String[0]), jibContainer.getImageId().toString());
    }

    private void doWriteOutputFile(OutputTargetBuildItem outputTarget, Path configPath, String output) {
        if (!configPath.isAbsolute()) {
            configPath = outputTarget.getOutputDirectory().resolve(configPath);
        }
        try {
            Files.write(configPath, output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Unable to write file '%s'.", (Object)configPath.toAbsolutePath().toString());
        }
    }

    private RegistryImage toRegistryImage(ImageReference imageReference, Optional<String> username, Optional<String> password) {
        CredentialRetrieverFactory credentialRetrieverFactory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, arg_0 -> ((Logger)log).info(arg_0));
        RegistryImage registryImage = RegistryImage.named((ImageReference)imageReference);
        if (username.isPresent() && password.isPresent()) {
            registryImage.addCredential(username.get(), password.get());
        } else {
            registryImage.addCredentialRetriever(credentialRetrieverFactory.wellKnownCredentialHelpers());
            registryImage.addCredentialRetriever(credentialRetrieverFactory.dockerConfig());
        }
        return registryImage;
    }

    private Logger.Level toJBossLoggingLevel(LogEvent.Level level) {
        switch (level) {
            case ERROR: {
                return Logger.Level.ERROR;
            }
            case WARN: {
                return Logger.Level.WARN;
            }
            case LIFECYCLE: {
                return Logger.Level.INFO;
            }
        }
        return Logger.Level.DEBUG;
    }

    private JibContainerBuilder createContainerBuilderFromFastJar(JibConfig jibConfig, ContainerImageConfig containerImageConfig, JarBuildItem sourceJarBuildItem, CurateOutcomeBuildItem curateOutcome, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<AppCDSResultBuildItem> appCDSResult) {
        List<String> entrypoint;
        Path componentsPath = sourceJarBuildItem.getPath().getParent();
        Path appLibDir = componentsPath.resolve("lib").resolve("main");
        AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)"/work");
        if (jibConfig.jvmEntrypoint.isPresent()) {
            entrypoint = jibConfig.jvmEntrypoint.get();
        } else {
            List<String> effectiveJvmArguments = this.determineEffectiveJvmArguments(jibConfig, appCDSResult);
            entrypoint = new ArrayList<String>(3 + effectiveJvmArguments.size());
            entrypoint.add("java");
            entrypoint.addAll(effectiveJvmArguments);
            entrypoint.add("-jar");
            entrypoint.add("quarkus-run.jar");
        }
        ArrayList<ResolvedDependency> fastChangingLibs = new ArrayList<ResolvedDependency>();
        Collection userDependencies = curateOutcome.getApplicationModel().getRuntimeDependencies();
        for (ResolvedDependency artifact : userDependencies) {
            String artifactVersion;
            if (artifact == null || (artifactVersion = artifact.getVersion()) == null || artifactVersion.isEmpty() || !artifactVersion.toLowerCase().contains("snapshot")) continue;
            fastChangingLibs.add(artifact);
        }
        Set fastChangingLibPaths = Collections.emptySet();
        ArrayList<Path> nonFastChangingLibPaths = null;
        if (!fastChangingLibs.isEmpty()) {
            fastChangingLibPaths = new HashSet(fastChangingLibs.size());
            HashMap<String, Path> libNameToPath = new HashMap<String, Path>();
            try (DirectoryStream<Path> allLibPaths = Files.newDirectoryStream(appLibDir);){
                for (Path path : allLibPaths) {
                    libNameToPath.put(path.getFileName().toString(), path);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ArrayList libFileNames = new ArrayList(libNameToPath.keySet());
            for (ResolvedDependency resolvedDependency : fastChangingLibs) {
                String matchingLibDirFileName = null;
                for (Path appArtifactPath : resolvedDependency.getResolvedPaths()) {
                    for (String libFileName : libFileNames) {
                        if (!libFileName.contains(resolvedDependency.getGroupId()) || !libFileName.contains(appArtifactPath.getFileName().toString())) continue;
                        matchingLibDirFileName = libFileName;
                        break;
                    }
                    if (matchingLibDirFileName == null) continue;
                    break;
                }
                if (matchingLibDirFileName == null) continue;
                fastChangingLibPaths.add((Path)libNameToPath.get(matchingLibDirFileName));
            }
            Collection allLibPaths = libNameToPath.values();
            nonFastChangingLibPaths = new ArrayList<Path>(allLibPaths.size() - fastChangingLibPaths.size());
            for (Path libPath : allLibPaths) {
                if (fastChangingLibPaths.contains(libPath)) continue;
                nonFastChangingLibPaths.add(libPath);
            }
        }
        try {
            JibContainerBuilder jibContainerBuilder = Jib.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseJvmImage), jibConfig.baseRegistryUsername, jibConfig.baseRegistryPassword));
            if (fastChangingLibPaths.isEmpty()) {
                jibContainerBuilder.addLayer(Collections.singletonList(componentsPath.resolve("lib")), workDirInContainer);
            } else {
                FileEntriesLayer.Builder bootLibsLayerBuilder = FileEntriesLayer.builder();
                Path bootLibPath = componentsPath.resolve("lib").resolve("boot");
                Files.list(bootLibPath).forEach(lib -> {
                    try {
                        AbsoluteUnixPath libPathInContainer = workDirInContainer.resolve("lib").resolve("boot").resolve(lib.getFileName());
                        if (appCDSResult.isPresent()) {
                            bootLibsLayerBuilder.addEntry(lib, libPathInContainer, Files.getLastModifiedTime(lib, new LinkOption[0]).toInstant());
                        } else {
                            bootLibsLayerBuilder.addEntry(lib, libPathInContainer);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                jibContainerBuilder.addFileEntriesLayer(bootLibsLayerBuilder.build());
                Path path = componentsPath.resolve("lib").resolve("deployment");
                if (Files.exists(path, new LinkOption[0])) {
                    FileEntriesLayer.Builder deploymentLayerBuilder = FileEntriesLayer.builder();
                    Files.list(path).forEach(lib -> {
                        AbsoluteUnixPath libPathInContainer = workDirInContainer.resolve("lib").resolve("deployment").resolve(lib.getFileName());
                        deploymentLayerBuilder.addEntry(lib, libPathInContainer);
                    });
                    jibContainerBuilder.addFileEntriesLayer(deploymentLayerBuilder.build());
                }
                jibContainerBuilder.addLayer(nonFastChangingLibPaths, workDirInContainer.resolve("lib").resolve("main"));
                jibContainerBuilder.addLayer(new ArrayList(fastChangingLibPaths), workDirInContainer.resolve("lib").resolve("main"));
            }
            if (appCDSResult.isPresent()) {
                jibContainerBuilder.addFileEntriesLayer(FileEntriesLayer.builder().addEntry(componentsPath.resolve("quarkus-run.jar"), workDirInContainer.resolve("quarkus-run.jar"), Files.getLastModifiedTime(componentsPath.resolve("quarkus-run.jar"), new LinkOption[0]).toInstant()).build());
                jibContainerBuilder.addLayer(Collections.singletonList(appCDSResult.get().getAppCDS()), workDirInContainer);
            } else {
                jibContainerBuilder.addFileEntriesLayer(FileEntriesLayer.builder().addEntry(componentsPath.resolve("quarkus-run.jar"), workDirInContainer.resolve("quarkus-run.jar")).build());
            }
            jibContainerBuilder.addLayer(Collections.singletonList(componentsPath.resolve("app")), workDirInContainer).addLayer(Collections.singletonList(componentsPath.resolve("quarkus")), workDirInContainer).setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(this.getEnvironmentVariables(jibConfig)).setLabels(this.allLabels(jibConfig, containerImageConfig, containerImageLabels)).setCreationTime(Instant.now());
            for (int port : jibConfig.ports) {
                jibContainerBuilder.addExposedPort(Port.tcp((int)port));
            }
            return jibContainerBuilder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> determineEffectiveJvmArguments(JibConfig jibConfig, Optional<AppCDSResultBuildItem> appCDSResult) {
        ArrayList<String> effectiveJvmArguments = new ArrayList<String>(jibConfig.jvmArguments);
        if (appCDSResult.isPresent()) {
            boolean containsAppCDSOptions = false;
            for (String effectiveJvmArgument : effectiveJvmArguments) {
                if (!effectiveJvmArgument.startsWith("-XX:SharedArchiveFile")) continue;
                containsAppCDSOptions = true;
                break;
            }
            if (!containsAppCDSOptions) {
                effectiveJvmArguments.add("-XX:SharedArchiveFile=" + appCDSResult.get().getAppCDS().getFileName().toString());
            }
        }
        return effectiveJvmArguments;
    }

    private void setUser(JibConfig jibConfig, JibContainerBuilder jibContainerBuilder) {
        jibConfig.user.ifPresent(arg_0 -> ((JibContainerBuilder)jibContainerBuilder).setUser(arg_0));
    }

    private void setPlatforms(JibConfig jibConfig, JibContainerBuilder jibContainerBuilder) {
        jibConfig.platforms.map(PlatformHelper::parse).ifPresent(arg_0 -> ((JibContainerBuilder)jibContainerBuilder).setPlatforms(arg_0));
    }

    private JibContainerBuilder createContainerBuilderFromLegacyJar(JibConfig jibConfig, ContainerImageConfig containerImageConfig, JarBuildItem sourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, MainClassBuildItem mainClassBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        try {
            Path classesDir = outputTargetBuildItem.getOutputDirectory().resolve(JIB);
            ZipUtils.unzip((Path)sourceJarBuildItem.getPath(), (Path)classesDir);
            JavaContainerBuilder javaContainerBuilder = JavaContainerBuilder.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseJvmImage), jibConfig.baseRegistryUsername, jibConfig.baseRegistryPassword)).addResources(classesDir, IS_CLASS_PREDICATE.negate()).addClasses(classesDir, (Predicate)IS_CLASS_PREDICATE);
            if (!jibConfig.jvmEntrypoint.isPresent()) {
                javaContainerBuilder.addJvmFlags(jibConfig.jvmArguments).setMainClass(mainClassBuildItem.getClassName());
            }
            if (sourceJarBuildItem.getLibraryDir() != null) {
                try (Stream<Path> dependenciesPaths = Files.list(sourceJarBuildItem.getLibraryDir());){
                    javaContainerBuilder.addDependencies(dependenciesPaths.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".jar")).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toList()));
                }
            }
            JibContainerBuilder jibContainerBuilder = javaContainerBuilder.toContainerBuilder().setEnvironment(this.getEnvironmentVariables(jibConfig)).setLabels(this.allLabels(jibConfig, containerImageConfig, containerImageLabels)).setCreationTime(Instant.now());
            if (jibConfig.jvmEntrypoint.isPresent()) {
                jibContainerBuilder.setEntrypoint(jibConfig.jvmEntrypoint.get());
            }
            return jibContainerBuilder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private JibContainerBuilder createContainerBuilderFromNative(JibConfig jibConfig, ContainerImageConfig containerImageConfig, NativeImageBuildItem nativeImageBuildItem, List<ContainerImageLabelBuildItem> containerImageLabels) {
        List<String> entrypoint;
        if (jibConfig.nativeEntrypoint.isPresent()) {
            entrypoint = jibConfig.nativeEntrypoint.get();
        } else {
            List nativeArguments = jibConfig.nativeArguments.orElse(Collections.emptyList());
            entrypoint = new ArrayList<String>(nativeArguments.size() + 1);
            entrypoint.add("./application");
            entrypoint.addAll(nativeArguments);
        }
        try {
            AbsoluteUnixPath workDirInContainer = AbsoluteUnixPath.get((String)"/work");
            JibContainerBuilder jibContainerBuilder = Jib.from((RegistryImage)this.toRegistryImage(ImageReference.parse((String)jibConfig.baseNativeImage), jibConfig.baseRegistryUsername, jibConfig.baseRegistryPassword)).addFileEntriesLayer(FileEntriesLayer.builder().addEntry(nativeImageBuildItem.getPath(), workDirInContainer.resolve(BINARY_NAME_IN_CONTAINER), FilePermissions.fromOctalString((String)"775")).build()).setWorkingDirectory(workDirInContainer).setEntrypoint(entrypoint).setEnvironment(this.getEnvironmentVariables(jibConfig)).setLabels(this.allLabels(jibConfig, containerImageConfig, containerImageLabels)).setCreationTime(Instant.now());
            for (int port : jibConfig.ports) {
                jibContainerBuilder.addExposedPort(Port.tcp((int)port));
            }
            return jibContainerBuilder;
        }
        catch (InvalidImageReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getEnvironmentVariables(JibConfig jibConfig) {
        Map<String, String> original = jibConfig.environmentVariables;
        if (original.isEmpty()) {
            return original;
        }
        HashMap<String, String> converted = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : original.entrySet()) {
            converted.put(entry.getKey().toUpperCase().replace('-', '_').replace('.', '_').replace('/', '_'), entry.getValue());
        }
        return converted;
    }

    private void handleExtraFiles(OutputTargetBuildItem outputTarget, JibContainerBuilder jibContainerBuilder) {
        Path outputDirectory = outputTarget.getOutputDirectory();
        PathsUtil.findMainSourcesRoot((Path)outputTarget.getOutputDirectory());
        AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
        if (mainSourcesRoot == null) {
            return;
        }
        Path jibFilesRoot = ((Path)mainSourcesRoot.getKey()).resolve(JIB);
        if (!jibFilesRoot.toFile().exists()) {
            return;
        }
        try {
            FileEntriesLayer extraFilesLayer = ContainerBuilderHelper.extraDirectoryLayerConfiguration(jibFilesRoot, AbsoluteUnixPath.get((String)"/"), Collections.emptyMap(), (localPath, ignored2) -> {
                try {
                    return Files.getLastModifiedTime(localPath, new LinkOption[0]).toInstant();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            jibContainerBuilder.addFileEntriesLayer(extraFilesLayer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to add extra files in '" + jibFilesRoot.toAbsolutePath().toString() + "' to the container", e);
        }
    }

    private Map<String, String> allLabels(JibConfig jibConfig, ContainerImageConfig containerImageConfig, List<ContainerImageLabelBuildItem> containerImageLabels) {
        if (jibConfig.labels.isEmpty() && containerImageLabels.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> allLabels = new HashMap<String, String>(jibConfig.labels);
        allLabels.putAll(containerImageConfig.labels);
        for (ContainerImageLabelBuildItem containerImageLabel : containerImageLabels) {
            allLabels.putIfAbsent(containerImageLabel.getName(), containerImageLabel.getValue());
        }
        return allLabels;
    }

    private static class IsClassPredicate
    implements Predicate<Path> {
        private IsClassPredicate() {
        }

        @Override
        public boolean test(Path path) {
            return path.getFileName().toString().endsWith(".class");
        }
    }
}

