/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.openshift.deployment;

import io.quarkus.container.image.openshift.deployment.BuildStrategy;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class OpenshiftConfig {
    public static final String DEFAULT_BASE_JVM_IMAGE = "registry.access.redhat.com/ubi8/openjdk-11";
    public static final String DEFAULT_BASE_NATIVE_IMAGE = "quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0";
    public static final String DEFAULT_NATIVE_TARGET_FILENAME = "application";
    public static final String DEFAULT_JVM_DOCKERFILE = "src/main/docker/Dockerfile.jvm";
    public static final String DEFAULT_NATIVE_DOCKERFILE = "src/main/docker/Dockerfile.native";
    @ConfigItem(defaultValue="binary")
    public BuildStrategy buildStrategy;
    @ConfigItem(defaultValue="registry.access.redhat.com/ubi8/openjdk-11")
    public String baseJvmImage;
    @ConfigItem(defaultValue="quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0")
    public String baseNativeImage;
    @ConfigItem(defaultValue="src/main/docker/Dockerfile.jvm")
    public String jvmDockerfile;
    @ConfigItem(defaultValue="src/main/docker/Dockerfile.native")
    public String nativeDockerfile;
    @ConfigItem(defaultValue="-Dquarkus.http.host=0.0.0.0,-Djava.util.logging.manager=org.jboss.logmanager.LogManager")
    public List<String> jvmArguments;
    @ConfigItem(defaultValue="-Dquarkus.http.host=0.0.0.0")
    public List<String> nativeArguments;
    @ConfigItem(defaultValue="/deployments/target/")
    public String jarDirectory;
    @ConfigItem
    public Optional<String> jarFileName;
    @ConfigItem(defaultValue="/home/quarkus/")
    public String nativeBinaryDirectory;
    @ConfigItem
    public Optional<String> nativeBinaryFileName;
    @ConfigItem(defaultValue="PT5M")
    Duration buildTimeout;

    public boolean hasDefaultBaseJvmImage() {
        return this.baseJvmImage.equals(DEFAULT_BASE_JVM_IMAGE);
    }

    public boolean hasDefaultBaseNativeImage() {
        return this.baseNativeImage.equals(DEFAULT_BASE_NATIVE_IMAGE);
    }

    public boolean hasDefaultJvmDockerfile() {
        return this.jvmDockerfile.equals(DEFAULT_JVM_DOCKERFILE);
    }

    public boolean hasDefaultativeDockerfile() {
        return this.nativeDockerfile.equals(DEFAULT_NATIVE_DOCKERFILE);
    }
}

